/*
** 
**  $Header: /usr/home/hellmann/nedit_add_ons/RCS/mcflow.c,v 1.30 96/03/18 11:00:30 hellmann Exp $
** 
**  FILENAME: mcflow.c
** 
**   PURPOSE: Display a calltree (*not* graph) based on output from cflow
** 
**    AUTHOR: Doug Hellmann
** 
**    RCSLOG:   $Log:	mcflow.c,v $
** Revision 1.30  96/03/18  11:00:30  hellmann
** Fixed Aldora colors
** 
** Revision 1.29  96/03/04  16:38:30  hellmann
** Fixed resource specs.
** 
** Revision 1.28  96/03/01  15:10:12  hellmann
** Attempt to make colors and other resources more consistent.
** 
** Revision 1.27  96/02/29  08:58:36  hellmann
** Don't even load the tags file
** 
** Revision 1.26  96/02/21  17:39:37  hellmann
** Added/updated header.
** 
** 
** 
*/

#include "client.h"
#include "calltree.h"
#include "xcalltre.h"
#include "Aldora.h"

CallTree * call_tree = NULL;
XtAppContext context;

#ifdef LOCAL_PREF_FILE_NAME
#undef LOCAL_PREF_FILE_NAME
#endif
#define LOCAL_PREF_FILE_NAME ".mcflow"

#ifdef APP_NAME
#undef APP_NAME
#endif
#define APP_NAME "mcflow" /* application name for loading resources */

#ifdef APP_CLASS
#undef APP_CLASS
#endif
#define APP_CLASS "MCflow"

char HeaderText[] = "\
# Preferences file for MCflow\n\
#\n\
# This file is created automatically by MCflow.\n\
#\n\
# Codes to be embedded in editor option: \n\
#\n\
#    %f - filename\n\
#    %t - tag name\n\
#    %l - line number\n\
#\n";

char *fallbackResources[] = {
    "NEdit*menuBar.marginHeight: 1",
    "NEdit*pane.sashHeight: 11",
    "NEdit*pane.sashWidth: 11",
    "NEdit*text.selectionArrayCount: 3",
    "NEdit*fontList:-adobe-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-*",
    "NEdit*XmList.fontList:-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*",
    "NEdit*XmText.fontList:-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*",
    "NEdit*XmTextField.fontList:-adobe-courier-medium-r-normal-*-12-*-*-*-*-*-*-*",
    
    "NEdit*XmText.background: white",
    "NEdit*XmText.foreground: black",
    "NEdit*XmTextField.background: white",
    "NEdit*XmTextField.foreground: black",
    "NEdit*XmList.background: white",
    "NEdit*XmList.foreground: black",
    "NEdit*background: grey",
    "NEdit*foreground: black",
    "NEdit*XmLabel*background: grey",
    "NEdit*XmLabel*foreground: black",

    "NEdit*call_tree_SW.scrollingPolicy: AUTOMATIC",
    "NEdit*call_tree_SW.scrollBarDisplayPolicy: STATIC",
    
    "NEdit*direction_menu*button_0.labelString: Functions referenced by :",
    "NEdit*direction_menu*button_1.labelString: Functions which reference :",

    "NEdit*mode_menu*button_0.labelString: Simple expansion",
    "NEdit*mode_menu*button_1.labelString: Search",
    
    "NEdit*call_tree.foreground: green",

/*
    "*tree_node*XmPushButton*background: grey",
    "*tree_node*XmLabel*background: grey",
    "*tree_node*foreground: cyan",
*/
    
/*
    "*tree_node.reroot_btn.foreground: black",
*/

    "NEdit*tree_node.reroot_btn.background: IndianRed",
    "NEdit*tree_node.reroot_btn.foreground: IndianRed",
    "NEdit*tree_node.reroot_btn.fontList:-adobe-helvetica-bold-r-normal-*-16-*-*-*-*-*-*-*",

    "NEdit*tree_node.tag_btn.foreground: yellow",
    "NEdit*tree_node.tag_btn.background: DarkSlateGrey",

    "NEdit*tree_node.tag_label.foreground: DarkSlateGrey",
    "NEdit*tree_node.tag_label.background: grey",
    "NEdit*tree_node.tag_label.fontList:-adobe-helvetica-bold-o-normal-*-14-*-*-*-*-*-*-*",

/*
    "*tree_node.collapse_btn.foreground: black",
*/

    "NEdit*tree_node.collapse_btn.background: SlateBlue",
    "NEdit*tree_node.collapse_btn.foreground: SlateBlue",
    "*tree_node.collapse_btn.fontList:-adobe-helvetica-bold-r-normal-*-16-*-*-*-*-*-*-*",
    
/*
    "*tree_node.expand_btn.foreground: black",
*/

    "NEdit*tree_node.expand_btn.background: SlateBlue",
    "NEdit*tree_node.expand_btn.foreground: SlateBlue",
    "NEdit*tree_node.expand_btn.fontList:-adobe-helvetica-bold-r-normal-*-16-*-*-*-*-*-*-*",

    "*AldoraHelp*background: lemon chiffon",
    "*AldoraHelp*foreground: black",
    
    "NEdit*XmToggleButton.selectorColor: red",

    NULL
};

char cmdLineHelp[] =
#ifndef VMS
"Usage:  mcflow [-cflowFile call_tree_file] [-cflowExpandDepth number] \n\
		[-editor editor_name]\n\
		[-font font] [-display [host]:server[.screen]\n\
               [-geometry geometry] [-xrm resourcestring] [file...]\n";
#else
"";
#endif /*VMS*/

XrmOptionDescRec LocalOpTable[] = {
    {"-cflowFile", ".cflowFile", XrmoptionSepArg, (caddr_t)NULL},
    {"-cflowExpandDepth", ".cflowExpandDepth", XrmoptionSepArg, (caddr_t)NULL},
    {"-editor", ".editor", XrmoptionSepArg, (caddr_t)NULL},
};

struct localPrefData {
    char cflowCommand[MAXPATHLEN];	/* command to run cflow */
    char cflowFile[MAXPATHLEN];		/* file where cflow output is already stored */
    int cflowExpandDepth;		/* automatically expand cflow tree this far */
    int neditUser;			/* does the user use nedit as an editor? */
    int balloonHelp;			/* should Aldora Help be used? */
    int showUnknown;			/* show functions lacking definitions? */
    char editor[MAXPATHLEN];		/* name of editor command under X */
} LocalPrefData;

PrefDescripRec LocalPrefDescrip[] = {
    {"cflowCommand", "CflowCommand", PREF_STRING,
    	"cflow *.i",
    	LocalPrefData.cflowCommand, (void *)sizeof(LocalPrefData.cflowCommand), True},
    {"cflowFile", "CflowFile", PREF_STRING,
    	"cflow.tree",
    	LocalPrefData.cflowFile, (void *)sizeof(LocalPrefData.cflowFile), True},
    {"cflowExpandDepth", "CflowExpandDepth", PREF_INT, "1",
    	&LocalPrefData.cflowExpandDepth, NULL, True},
    {"neditUser", "NeditUser", PREF_BOOLEAN, "False",
    	&LocalPrefData.neditUser, NULL, True},
    {"balloonHelp", "BalloonHelp", PREF_BOOLEAN, "True",
    	&LocalPrefData.balloonHelp, NULL, True},
    {"editor", "editor", PREF_STRING,
    	"xterm -title %f -exec vi +%l %f &",
    	LocalPrefData.editor, (void *)sizeof(LocalPrefData.editor), True},
    {"showUnknown", "ShowUnknown", PREF_BOOLEAN, "True",
    	&LocalPrefData.showUnknown, NULL, True},
};

/*
** Functions to return preferences values.
*/

char * GetPrefCflowFile(void)
{
    return LocalPrefData.cflowFile;
}

char * GetPrefCflowCommand(void)
{
    return LocalPrefData.cflowCommand;
}

int GetPrefCflowExpandDepth(void)
{
  return LocalPrefData.cflowExpandDepth;
}

void SetPrefCflowExpandDepth(int new_depth)
{
  LocalPrefData.cflowExpandDepth = new_depth;
}

int GetPrefNeditUser(void)
{
  return LocalPrefData.neditUser;
}

int GetPrefBalloonHelp(void)
{
  return LocalPrefData.balloonHelp;
}

int GetPrefShowUnknown(void)
{
  return LocalPrefData.showUnknown;
}

char * GetPrefEditorCommand(void)
{
  return LocalPrefData.editor;
}

/*
 *
 * PURPOSE: Change the expansion depth preference and resave prefs.
 * 
 * CALLED AS RESULT OF: Scale widget.
 *
*/
void  ChangeExpansionDepthCB(Widget w, XtPointer xtp1, XtPointer xtp2)
{
  XmScaleCallbackStruct * cbs = (XmScaleCallbackStruct*) xtp2;
  
  SetPrefCflowExpandDepth(cbs->value);
  
/*
  SavePreferences(TheDisplay, LOCAL_PREF_FILE_NAME, HeaderText,
    	  LocalPrefDescrip, XtNumber(LocalPrefDescrip)); 
*/

}


/*
** Main function
*/

int main(int argc, char **argv)
{
    int i, fileSpecified;
    XrmDatabase prefDB, localPrefDB;
    Widget dialog;
    
    /* Initialize toolkit and open display. */

    XtToolkitInitialize();
    context = XtCreateApplicationContext();
    if (!context)
    {
	XtWarning ("MCflow: Can't get context\n");
	exit(0);
    }

    /* Set up a warning handler to trap obnoxious Xt grab warnings */
    SuppressPassiveGrabWarnings();

    /* Set up default resources if no app-defaults file is found */
    XtAppSetFallbackResources(context, fallbackResources);
    
#if XmVersion >= 1002
    /* Allow users to change tear off menus with X resources */
    XmRepTypeInstallTearOffModelConverter();
#endif /* XmVersion */
    
#ifdef VMS
    /* Convert the command line to Unix style (This is not an ideal solution) */
    ConvertVMSCommandLine(&argc, &argv);
#endif /*VMS*/
    
    /* Read the preferences file and command line into a database */
    prefDB = CreateNEditPrefDB(&argc, argv);
    localPrefDB = CreateLocalPrefDB(LOCAL_PREF_FILE_NAME, APP_NAME, 
    			LocalOpTable, XtNumber(LocalOpTable), &argc, argv);

    /* Open the display and read X database and remaining command line args */
    
    TheDisplay = XtOpenDisplay (context, NULL, APP_NAME, APP_CLASS, NULL,
    	    0, &argc, argv);

    if (!TheDisplay) {
	XtWarning ("MCflow: Can't open display\n");
	exit(0);
    }

    /* Store preferences from the command line and .mcflow file, 
       and set the appropriate preferences */
    RestoreNEditPrefs(prefDB, XtDatabase(TheDisplay));
    RestoreLocalPrefs(APP_NAME, LocalPrefDescrip, XtNumber(LocalPrefDescrip),
    			localPrefDB, XtDatabase(TheDisplay));
    SetPointerCenteredDialogs(GetPrefRepositionDialogs());
    
    SavePreferences(TheDisplay, LOCAL_PREF_FILE_NAME, HeaderText,
    	    LocalPrefDescrip, XtNumber(LocalPrefDescrip)); 
    	    
    /* Process any command line arguments (-tags, and files to edit) not
       already processed by RestoreNEditPrefs. */
    fileSpecified = FALSE;
        
    dialog = CallTree_DialogCreate();
    XtPopup(dialog, XtGrabNone);

    CallTree_UpdateDisplayFromFileCB(NULL, NULL, NULL);
    
    /* Process events. */
    XtAppMainLoop(context);

    return 0;
}
