#ifndef _NO_PROTO
#ifndef _STRINGOBJ_H_

#define _STRINGOBJ_H_
/*-------------------------------------------------------------*/
/*                        stringobj.h                          */
/*-------------------------------------------------------------*/

/*
	Doug Hellmann
	June, 1992
*/

/*
  A string handler module implementing the abstract idea of a character
  string. The characters of the string are indexed beginning from 0.
*/


struct StringStruct;
typedef struct StringStruct StringObj;

StringObj* StringObj_Create (char p[]);
    /* Create a "StringObj" object from the null-terminated array p; */
    /* return a pointer to the newly-created object. */

void StringObj_Destroy (StringObj* strg);
    /* Destroy the string pointed to by the parameter (free the memory */
    /* it uses). */

int StringObj_Length (StringObj* strg);
    /* Return the number of characters in the string object strg */

int StringObj_CharIndex (StringObj* strg, int position, char c[]);
    /* Return the leftmost position in strg, at or to the right of the */
    /* parameter "position," at which any of the characters in the */
    /* null-terminated character array c occurs; return -1 if no */
    /* character in c occurs at or after "position." */ 

int StringObj_NCharIndex (StringObj* strg, int position, char c[]);
    /* Return the leftmost position in strg, at or to the right of the */
    /* parameter "position," at which any  character other than those in */
    /* the null-terminated character array c occurs; return -1 if no */
    /* character in c occurs at or after "position." */ 

int StringObj_StrgIndex (StringObj* strg, int position, char s[]);
    /* Return the leftmost position in strg, at or to the right of the */
    /* parameter "position," at which the string s occurs; return -1 */
    /* if it does not occur at or after "position." */ 

void StringObj_Concat (StringObj* strg, char s[]);
    /* Concatenate s onto the end of strg. */

char StringObj_CharAt (StringObj* strg, int position);
    /* Return the character at the specified position in the string */
    /* strg. Return a null character if "position" is outside the */
    /* range of positions for strg. */

void StringObj_AssignStringObj (StringObj* strg, StringObj* another_strg);
    /* Change the contents of strg so that they are a copy of the */
    /* contents of another_strg. Remember that the old value of strg */
    /* must be freed. */


void StringObj_AssignCharArray (StringObj* strg, char array[]);
    /* Change the contents of strg so that they are a copy of the */
    /* contents of array, which is a null-terminated character array. */
    /* Remember that the old value of strg must be freed. */

char * StringObj_AsString(StringObj * strg);
    /* Returns the ADT string as a normal C string */

#endif

#else

#ifndef _STRINGOBJ_H_

#define _STRINGOBJ_H_

struct StringStruct;
typedef struct StringStruct StringObj;

StringObj* StringObj_Create ();
void StringObj_Destroy ();
int StringObj_Length ();
int StringObj_CharIndex ();
int StringObj_NCharIndex ();
int StringObj_StrgIndex ();
void StringObj_Concat ();
char StringObj_CharAt ();
void StringObj_AssignStringObj ();
void StringObj_AssignCharArray ();
char * StringObj_AsString();

#endif
#endif
