.\" Copyright 1994, 1998  The Open Group
.\"
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation.
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of The Open Group shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from The Open Group.
.\"
.TH SESSREG __appmansuffix__ 2025-03-22 __xorgversion__
.SH NAME
sessreg \- manage __utmp_manpage__/__wtmp_manpage__ entries for non-init clients
.SH SYNOPSIS
.nf
\fBsessreg\fP \
[\fB\-w\fP \fI__wtmp_manpage__-file\fP] \
[\fB\-u\fP \fI__utmp_manpage__-file\fP] \
[\fB\-L\fP \fIlastlog-file\fP]
    [\fB\-l\fP \fIline-name\fP] \
[\fB\-h\fP \fIhost-name\fP] \
[\fB\-s\fP \fIslot-number\fP]
    [\fB\-x\fP \fIXservers-file\fP] \
[\fB\-t\fP \fIttys-file\fP] \
[\fB\-V\fP] \
[\fB\-a\fP] \
[\fB\-d\fP] \
\fIuser-name\fP
.fi
.SH DESCRIPTION
\fBSessreg\fP is a simple program for managing __utmp_manpage__/__wtmp_manpage__
and lastlog entries for xdm sessions.
.\" __BEGIN_UTMP_ONLY__
.PP
System V has a better interface to utmp than BSD; it
dynamically allocates entries in the file, instead of writing them at fixed
positions indexed by position in
.BR __ttys_file__ .
.PP
To manage BSD-style utmp files, \fBsessreg\fP has two strategies.  In
conjunction with xdm, the -x option counts the number of lines in
.B __ttys_file__
and then adds to that the number of the line in the Xservers file which
specifies the display.  The display name must be specified as the
"line-name" using the -l option.  This sum is used as the "slot-number" in
the utmp file that this entry will be written at.  In the more general case,
the -s option specifies the slot-number directly.  If for some strange reason
your system uses a file other than
.B __ttys_file__
to manage init, the -t option can direct
\fBsessreg\fP to look elsewhere for a count of terminal sessions.
.PP
Conversely, System V managers will not ever need to use these options
(\fB-x\fP, \fB-s\fP, and \fB-t\fP).
To make the program easier to document and explain,
\fBsessreg\fP accepts the BSD-specific flags in the System V
environment and ignores them.
.PP
BSD and Linux also have a host-name field in the utmp file which doesn't
exist in System V.  This option is also ignored by the System V version of
\fBsessreg\fP.
.\" __END_UTMP_ONLY__
.\" __BEGIN_UTMPX_ONLY__
.PP
This version of \fBsessreg\fP is built using the modern POSIX
.BR pututxline (3c)
interfaces, which no longer require the slot-number, ttys-file, or
Xservers-file mappings.  For compatibility with older versions and other
operating systems, the \fB-s\fP, \fB-t\fP, and \fB-x\fP flags are accepted,
but ignored.
.\" __END_UTMPX_ONLY__
.SH USAGE
In Xstartup, place a call like:
.sp
.nf
       sessreg -a -l $DISPLAY -x /etc/X11/xdm/Xservers $USER
.fi
.sp
and in Xreset:
.sp
.nf
       sessreg -d -l $DISPLAY -x /etc/X11/xdm/Xservers $USER
.fi
.SH OPTIONS
.IP "\fB-w\fP \fI__wtmp_manpage__-file\fP"
This specifies an alternate __wtmp_manpage__ file, instead of
.BR __wtmp_file__ .
The special name "none" disables writing records to the __wtmp_manpage__ file.
.IP "\fB-u\fP \fI__utmp_manpage__-file\fP"
This specifies an alternate __utmp_manpage__ file, instead of
.BR __utmp_file__ .
The special name "none" disables writing records to the __utmp_manpage__ file.
.IP "\fB-L\fP \fIlastlog-file\fP"
This specifies an alternate lastlog file, instead of
.BR __lastlog_file__ ,
if the platform supports lastlog files.
The special name "none" disables writing records to the lastlog file.
.IP "\fB-l\fP \fIline-name\fP"
This describes the "line" name of the entry.  For terminal sessions,
this is the final pathname segment of the terminal device filename
(e.g. ttyd0).  For X sessions, it should probably be the local display name
given to the users session (e.g. :0).  If none is specified, the
terminal name will be determined with
.BR ttyname (__libmansuffix__)
and stripped of leading components.
.IP "\fB-h\fP \fIhost-name\fP"
This is set to indicate that the session was initiated from
a remote host.  In typical xdm usage, this options is not used.
.IP "\fB-s\fP \fIslot-number\fP"
.\" __BEGIN_UTMP_ONLY__
Each potential session has a unique slot number in BSD systems, most are
identified by the position of the \fIline-name\fP in the
.BR __ttys_file__ " file."
This option overrides the default position determined with
.BR ttyslot (__libmansuffix__).
This option is inappropriate for use with xdm, the -x option is more useful.
.\" __END_UTMP_ONLY__
.\" __BEGIN_UTMPX_ONLY__
This option is accepted for compatibility, but does nothing in
this version of \fBsessreg\fP.
.\" __END_UTMPX_ONLY__
.IP "\fB-x\fP \fIXservers-file\fP"
.\" __BEGIN_UTMP_ONLY__
As X sessions are one-per-display, and each display is entered in this file,
this options sets the \fIslot-number\fP to be the number of lines in
the \fIttys-file\fP plus the index into this file that the \fIline-name\fP
is found.
.\" __END_UTMP_ONLY__
.\" __BEGIN_UTMPX_ONLY__
This option is accepted for compatibility, but does nothing in
this version of \fBsessreg\fP.
.\" __END_UTMPX_ONLY__
.IP "\fB-t\fP \fIttys-file\fP"
.\" __BEGIN_UTMP_ONLY__
This specifies an alternate file which the \fI-x\fP option will use to count
the number of terminal sessions on a host.
.\" __END_UTMP_ONLY__
.\" __BEGIN_UTMPX_ONLY__
This option is accepted for compatibility, but does nothing in
this version of \fBsessreg\fP.
.\" __END_UTMPX_ONLY__
.IP "\fB-V\fP, \fB--version\fP"
This option causes the command to print its version and exit.
.IP "\fB-a\fP"
This session should be added to __utmp_manpage__/__wtmp_manpage__.
.IP "\fB-d\fP"
This session should be deleted from __utmp_manpage__/__wtmp_manpage__.
One of
.BR -a / -d
must be specified.
.SH "SEE ALSO"
.BR xdm (__appmansuffix__),
.BR __utmp_manpage__ (__filemansuffix__),
.BR __wtmp_manpage__ (__filemansuffix__)
.SH AUTHOR
Keith Packard, MIT X Consortium
