/* $NetBSD: sunxi_debereg.h,v 1.1 2018/04/03 12:52:16 bouyer Exp $ */

/*-
 * Copyright (c) 2013 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Matt Thomas of 3am Software Foundry.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#define SUNXI_DEBE_MODCTL_REG		0x0800
#define SUNXI_DEBE_BACKCOLOR_REG	0x0804
#define SUNXI_DEBE_DISSIZE_REG		0x0808
#define SUNXI_DEBE_LAYSIZE_REG		0x0810
#define SUNXI_DEBE_LAYCOOR_REG		0x0820
#define SUNXI_DEBE_LAYLINEWIDTH_REG	0x0840
#define SUNXI_DEBE_LAYFB_L32ADD_REG	0x0850
#define SUNXI_DEBE_LAYFB_H4ADD_REG	0x0860
#define SUNXI_DEBE_REGBUFFCTL_REG	0x0870
#define SUNXI_DEBE_CKMAX_REG		0x0880
#define SUNXI_DEBE_CKMIN_REG		0x0884
#define SUNXI_DEBE_CKCFG_REG		0x0888
#define SUNXI_DEBE_ATTCTL0_REG		0x0890
#define SUNXI_DEBE_ATTCTL1_REG		0x08A0
#define SUNXI_DEBE_HWCCTL_REG		0x08D8
#define SUNXI_DEBE_HWCFBCTL_REG		0x08E0
#define SUNXI_DEBE_WBCTL_REG		0x08F0
#define SUNXI_DEBE_WBADD_REG		0x08F4
#define SUNXI_DEBE_WBLINEWIDTH_REG	0x08F8
#define SUNXI_DEBE_IYUVCTL_REG		0x0920
#define SUNXI_DEBE_IYUVADD_REG		0x0930
#define SUNXI_DEBE_IYUVLINEWIDTH_REG	0x0940
#define SUNXI_DEBE_YGCOEF_REG		0x0950
#define SUNXI_DEBE_YGCONS_REG		0x095C
#define SUNXI_DEBE_URCOEF_REG		0x0960
#define SUNXI_DEBE_URCONS_REG		0x096C
#define SUNXI_DEBE_VBCOEF_REG		0x0970
#define SUNXI_DEBE_VBCONS_REG		0x097C
#define SUNXI_DEBE_OCCTL_REG		0x09C0
#define SUNXI_DEBE_OCRCOEF_REG		0x09D0
#define SUNXI_DEBE_OCRCONS_REG		0x09DC
#define SUNXI_DEBE_OCGCOEF_REG		0x09E0
#define SUNXI_DEBE_OCGCONS_REG		0x09EC
#define SUNXI_DEBE_OCBCOEF_REG		0x09F0
#define SUNXI_DEBE_OCBCONS_REG		0x09FC
#define SUNXI_DEBE_HWC_PATTERN_BLOCK	0x4800
#define SUNXI_DEBE_HWC_PALETTE_TABLE	0x4C00

#define SUNXI_DEBE_MODCTL_LINE_SEL	__BIT(29)
#define SUNXI_DEBE_MODCTL_ITLMOD_EN	__BIT(28)
#define SUNXI_DEBE_MODCTL_OUT_SEL	__BITS(22,20)
#define SUNXI_DEBE_MODCTL_OUT_SEL_LCD0	0
#define SUNXI_DEBE_MODCTL_OUT_SEL_LCD1	1
#define SUNXI_DEBE_MODCTL_OUT_SEL_FE0	6
#define SUNXI_DEBE_MODCTL_OUT_SEL_FE1	7
#define SUNXI_DEBE_MODCTL_OSCA_EN	__BIT(17)
#define SUNXI_DEBE_MODCTL_HWC_EN	__BIT(16)
#define SUNXI_DEBE_MODCTL_LAY3_EN	__BIT(11)
#define SUNXI_DEBE_MODCTL_LAY2_EN	__BIT(10)
#define SUNXI_DEBE_MODCTL_LAY1_EN	__BIT(9)
#define SUNXI_DEBE_MODCTL_LAY0_EN	__BIT(8)
#define SUNXI_DEBE_MODCTL_START_CTL	__BIT(1)
#define SUNXI_DEBE_MODCTL_EN		__BIT(0)

#define SUNXI_DEBE_ATTCTL0_LAY_GLBALPHA	__BITS(31,24)
#define SUNXI_DEBE_ATTCTL0_LAY_WORKMOD	__BITS(23,22)
#define SUNXI_DEBE_ATTCTL0_PREMUL	__BIT(21,20)
#define SUNXI_DEBE_ATTCTL0_CKEN		__BITS(19,18)
#define SUNXI_DEBE_ATTCTL0_LAY_PIPESEL	__BIT(15)
#define SUNXI_DEBE_ATTCTL0_LAY_PRISEL	__BITS(11,10)
#define SUNXI_DEBE_ATTCTL0_LAY_VDOSEL	__BIT(4)
#define SUNXI_DEBE_ATTCTL0_LAY_YUVEN	__BIT(2)
#define SUNXI_DEBE_ATTCTL0_LAY_VDOEN	__BIT(1)
#define SUNXI_DEBE_ATTCTL0_LAY_GLBALPHAEN __BIT(0)

#define SUNXI_DEBE_ATTCTL1_LAY_HSCAFCT	__BITS(15,14)
#define SUNXI_DEBE_ATTCTL1_LAY_WSCAFCT	__BITS(13,12)
#define SUNXI_DEBE_ATTCTL1_LAY_FBFMT	__BITS(11,8)
#define SUNXI_DEBE_ATTCTL1_LAY_FBFMT_MONO_1BPP	0
#define SUNXI_DEBE_ATTCTL1_LAY_FBFMT_MONO_2BPP	1
#define SUNXI_DEBE_ATTCTL1_LAY_FBFMT_MONO_4BPP	2
#define SUNXI_DEBE_ATTCTL1_LAY_FBFMT_MONO_8BPP	3
#define SUNXI_DEBE_ATTCTL1_LAY_FBFMT_RGB655	4
#define SUNXI_DEBE_ATTCTL1_LAY_FBFMT_RGB565	5
#define SUNXI_DEBE_ATTCTL1_LAY_FBFMT_RGB556	6
#define SUNXI_DEBE_ATTCTL1_LAY_FBFMT_ARGB1555	7
#define SUNXI_DEBE_ATTCTL1_LAY_FBFMT_RGBA5551	8
#define SUNXI_DEBE_ATTCTL1_LAY_FBFMT_XRGB8888	9
#define SUNXI_DEBE_ATTCTL1_LAY_FBFMT_ARGB8888	10
#define SUNXI_DEBE_ATTCTL1_LAY_FBFMT_RGB888	11
#define SUNXI_DEBE_ATTCTL1_LAY_FBFMT_ARGB4444	12
#define SUNXI_DEBE_ATTCTL1_LAY_FBFMT_RGBA4444	13
#define SUNXI_DEBE_ATTCTL1_LAY_BRSWAPEN	__BIT(2)
#define SUNXI_DEBE_ATTCTL1_LAY_FBPS	__BITS(1,0)
#define SUNXI_DEBE_ATTCTL1_LAY_FBPS_32BPP_ARGB	0
#define SUNXI_DEBE_ATTCTL1_LAY_FBPS_32BPP_BGRA	2

#define SUNXI_DEBE_REGBUFFCTL_REGAUTOLOAD_DIS __BIT(1)
#define SUNXI_DEBE_REGBUFFCTL_REGLOADCTL	__BIT(0)

#define SUNXI_DEBE_HWCCTL_YCOOR		__BITS(31,16)
#define SUNXI_DEBE_HWCCTL_XCOOR		__BITS(15,0)

#define SUNXI_DEBE_HWCFBCTL_YCOOROFF	__BITS(31,24)
#define SUNXI_DEBE_HWCFBCTL_XCOOROFF	__BITS(23,16)
#define SUNXI_DEBE_HWCFBCTL_YSIZE	__BITS(5,4)
#define SUNXI_DEBE_HWCFBCTL_YSIZE_32	0
#define SUNXI_DEBE_HWCFBCTL_YSIZE_64	1
#define SUNXI_DEBE_HWCFBCTL_XSIZE	__BITS(3,2)
#define SUNXI_DEBE_HWCFBCTL_XSIZE_32	0
#define SUNXI_DEBE_HWCFBCTL_XSIZE_64	1
#define SUNXI_DEBE_HWCFBCTL_FBFMT	__BITS(1,0)
#define SUNXI_DEBE_HWCFBCTL_FBFMT_1BPP	0
#define SUNXI_DEBE_HWCFBCTL_FBFMT_2BPP	1
#define SUNXI_DEBE_HWCFBCTL_FBFMT_4BPP	2
#define SUNXI_DEBE_HWCFBCTL_FBFMT_8BPP	3

