/* $NetBSD: fdt_boot.h,v 1.4 2024/01/19 09:09:04 skrll Exp $ */

/*-
 * Copyright (c) 2018 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Jared McNeill <jmcneill@invisible.ca>.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _DEV_FDT_FDT_BOOT_H_
#define _DEV_FDT_FDT_BOOT_H_

#ifdef EFI_RUNTIME
#include <machine/efirt.h>

void fdt_map_efi_runtime(const char *prop, enum cpu_efirt_mem_type type);
#endif

char *fdt_get_bootargs(void);

void fdt_probe_initrd(void);
void fdt_setup_initrd(void);
void fdt_reserve_initrd(void);
void fdt_probe_rndseed(void);
void fdt_setup_rndseed(void);
void fdt_reserve_rndseed(void);
void fdt_probe_efirng(void);
void fdt_setup_efirng(void);
void fdt_reserve_efirng(void);
void fdt_cpu_rootconf(void);

void fdt_update_stdout_path(void *, const char *);

#endif /* _DEV_FDT_FDT_BOOT_H_ */
