/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath;

import com.github.ajalt.colormath.Ansi16;
import com.github.ajalt.colormath.Ansi256;
import com.github.ajalt.colormath.CMYK;
import com.github.ajalt.colormath.ConvertibleColor;
import com.github.ajalt.colormath.ExtensionsKt;
import com.github.ajalt.colormath.HSL;
import com.github.ajalt.colormath.LAB;
import com.github.ajalt.colormath.RGB;
import com.github.ajalt.colormath.XYZ;
import kotlin.Metadata;
import kotlin.Triple;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0000H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/github/ajalt/colormath/HSV;", "Lcom/github/ajalt/colormath/ConvertibleColor;", "h", "", "s", "v", "(III)V", "getH", "()I", "getS", "getV", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toHSL", "Lcom/github/ajalt/colormath/HSL;", "toHSV", "toRGB", "Lcom/github/ajalt/colormath/RGB;", "toString", "", "colorconversion"})
public final class HSV
implements ConvertibleColor {
    private final int h;
    private final int s;
    private final int v;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public RGB toRGB() {
        void g;
        void r;
        Triple triple;
        double h = (double)this.h / (double)60;
        double s = (double)this.s / (double)100;
        double v = (double)this.v / (double)100;
        double hi = Math.floor(h) % (double)6;
        double f = h - Math.floor(h);
        double p = (double)255 * v * (1.0 - s);
        double q = (double)255 * v * (1.0 - s * f);
        double t = (double)255 * v * (1.0 - s * (1.0 - f));
        v *= (double)255;
        switch ((int)hi) {
            case 0: {
                triple = new Triple((Object)v, (Object)t, (Object)p);
                break;
            }
            case 1: {
                triple = new Triple((Object)q, (Object)v, (Object)p);
                break;
            }
            case 2: {
                triple = new Triple((Object)p, (Object)v, (Object)t);
                break;
            }
            case 3: {
                triple = new Triple((Object)p, (Object)q, (Object)v);
                break;
            }
            case 4: {
                triple = new Triple((Object)t, (Object)p, (Object)v);
                break;
            }
            default: {
                triple = new Triple((Object)v, (Object)p, (Object)q);
            }
        }
        Triple triple2 = triple;
        double d = ((Number)triple2.component1()).doubleValue();
        double d2 = ((Number)triple2.component2()).doubleValue();
        double b = ((Number)triple2.component3()).doubleValue();
        return new RGB(ExtensionsKt.roundToInt((double)r), ExtensionsKt.roundToInt((double)g), ExtensionsKt.roundToInt(b));
    }

    @Override
    @NotNull
    public HSL toHSL() {
        double h = this.h;
        double s = (double)this.s / (double)100;
        double v = (double)this.v / (double)100;
        double vmin = Math.max(v, 0.01);
        double l = ((double)2 - s) * v / (double)2;
        double lmin = ((double)2 - s) * vmin;
        double sl = s * vmin / (lmin <= 1.0 ? lmin : (double)2 - lmin);
        return new HSL(ExtensionsKt.roundToInt(h), ExtensionsKt.roundToInt(sl * (double)100), ExtensionsKt.roundToInt(l * (double)100));
    }

    @Override
    @NotNull
    public HSV toHSV() {
        return this;
    }

    public final int getH() {
        return this.h;
    }

    public final int getS() {
        return this.s;
    }

    public final int getV() {
        return this.v;
    }

    public HSV(int h, int s, int v) {
        this.h = h;
        this.s = s;
        this.v = v;
        int n = this.h;
        int n2 = n = 0 <= n && 360 >= n ? 1 : 0;
        if (n == 0) {
            String string = "h must be in range [0, 360]";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = this.s;
        int n3 = n = 0 <= n && 100 >= n ? 1 : 0;
        if (n == 0) {
            String string = "s must be in range [0, 100]";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        n = this.v;
        int n4 = n = 0 <= n && 100 >= n ? 1 : 0;
        if (n == 0) {
            String string = "v must be in range [0, 100]";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public String toHex(boolean withNumberSign) {
        return ConvertibleColor.DefaultImpls.toHex(this, withNumberSign);
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return ConvertibleColor.DefaultImpls.toAnsi16(this);
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return ConvertibleColor.DefaultImpls.toAnsi256(this);
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return ConvertibleColor.DefaultImpls.toCMYK(this);
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        return ConvertibleColor.DefaultImpls.toXYZ(this);
    }

    @Override
    @NotNull
    public LAB toLAB() {
        return ConvertibleColor.DefaultImpls.toLAB(this);
    }

    public final int component1() {
        return this.h;
    }

    public final int component2() {
        return this.s;
    }

    public final int component3() {
        return this.v;
    }

    @NotNull
    public final HSV copy(int h, int s, int v) {
        return new HSV(h, s, v);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ HSV copy$default(HSV hSV, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = hSV.h;
        }
        if ((n4 & 2) != 0) {
            n2 = hSV.s;
        }
        if ((n4 & 4) != 0) {
            n3 = hSV.v;
        }
        return hSV.copy(n, n2, n3);
    }

    public String toString() {
        return "HSV(h=" + this.h + ", s=" + this.s + ", v=" + this.v + ")";
    }

    public int hashCode() {
        return (this.h * 31 + this.s) * 31 + this.v;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof HSV)) break block3;
                HSV hSV = (HSV)object;
                if (!(this.h == hSV.h) || !(this.s == hSV.s) || !(this.v == hSV.v)) break block3;
            }
            return true;
        }
        return false;
    }
}

