/*
 * Decompiled with CFR 0.152.
 */
package io.mockk;

import io.mockk.APIKt;
import io.mockk.Matcher;
import io.mockk.MockKException;
import io.mockk.TypedMatcher;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B#\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0012\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u00c6\u0003J8\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0005\u001a\u00028\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00d6\u0001J\u0017\u0010\u001c\u001a\u00020\u00182\b\u0010\u001d\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eJ\"\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0!H\u0016J\b\u0010\"\u001a\u00020#H\u0016R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006$"}, d2={"Lio/mockk/ComparingMatcher;", "T", "", "Lio/mockk/Matcher;", "Lio/mockk/TypedMatcher;", "value", "cmpFunc", "", "argumentType", "Lkotlin/reflect/KClass;", "(Ljava/lang/Comparable;ILkotlin/reflect/KClass;)V", "getArgumentType", "()Lkotlin/reflect/KClass;", "getCmpFunc", "()I", "getValue", "()Ljava/lang/Comparable;", "Ljava/lang/Comparable;", "component1", "component2", "component3", "copy", "(Ljava/lang/Comparable;ILkotlin/reflect/KClass;)Lio/mockk/ComparingMatcher;", "equals", "", "other", "", "hashCode", "match", "arg", "(Ljava/lang/Comparable;)Z", "substitute", "map", "", "toString", "", "mockk-dsl"})
public final class ComparingMatcher<T extends Comparable<? super T>>
implements Matcher<T>,
TypedMatcher {
    @NotNull
    private final T value;
    private final int cmpFunc;
    @NotNull
    private final KClass<T> argumentType;

    public ComparingMatcher(@NotNull T value, int cmpFunc, @NotNull KClass<T> argumentType) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter(argumentType, (String)"argumentType");
        this.value = value;
        this.cmpFunc = cmpFunc;
        this.argumentType = argumentType;
    }

    @NotNull
    public final T getValue() {
        return this.value;
    }

    public final int getCmpFunc() {
        return this.cmpFunc;
    }

    @NotNull
    public KClass<T> getArgumentType() {
        return this.argumentType;
    }

    @Override
    public boolean match(@Nullable T arg) {
        boolean bl;
        if (arg == null) {
            return false;
        }
        int n = arg.compareTo(this.value);
        switch (this.cmpFunc) {
            case 2: {
                if (n >= 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 1: {
                if (n > 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 0: {
                if (n == 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case -1: {
                if (n < 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case -2: {
                if (n <= 0) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new MockKException("Bad comparison function", null, 2, null);
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public ComparingMatcher<T> substitute(@NotNull Map<Object, ? extends Object> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        return ComparingMatcher.copy$default(this, (Comparable)APIKt.internalSubstitute(this.value, map), 0, null, 6, null);
    }

    @NotNull
    public String toString() {
        String string;
        switch (this.cmpFunc) {
            case -2: {
                string = "lessAndEquals(" + this.value + ")";
                break;
            }
            case -1: {
                string = "less(" + this.value + ")";
                break;
            }
            case 0: {
                string = "cmpEq(" + this.value + ")";
                break;
            }
            case 1: {
                string = "more(" + this.value + ")";
                break;
            }
            case 2: {
                string = "moreAndEquals(" + this.value + ")";
                break;
            }
            default: {
                throw new MockKException("Bad comparison function", null, 2, null);
            }
        }
        return string;
    }

    @Override
    public boolean checkType(@Nullable Object arg) {
        return TypedMatcher.DefaultImpls.checkType(this, arg);
    }

    @NotNull
    public final T component1() {
        return this.value;
    }

    public final int component2() {
        return this.cmpFunc;
    }

    @NotNull
    public final KClass<T> component3() {
        return this.argumentType;
    }

    @NotNull
    public final ComparingMatcher<T> copy(@NotNull T value, int cmpFunc, @NotNull KClass<T> argumentType) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter(argumentType, (String)"argumentType");
        return new ComparingMatcher<T>(value, cmpFunc, argumentType);
    }

    public static /* synthetic */ ComparingMatcher copy$default(ComparingMatcher comparingMatcher, Comparable comparable, int n, KClass kClass, int n2, Object object) {
        if ((n2 & 1) != 0) {
            comparable = comparingMatcher.value;
        }
        if ((n2 & 2) != 0) {
            n = comparingMatcher.cmpFunc;
        }
        if ((n2 & 4) != 0) {
            kClass = comparingMatcher.argumentType;
        }
        return comparingMatcher.copy(comparable, n, kClass);
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = result * 31 + Integer.hashCode(this.cmpFunc);
        result = result * 31 + this.argumentType.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ComparingMatcher)) {
            return false;
        }
        ComparingMatcher comparingMatcher = (ComparingMatcher)other;
        if (!Intrinsics.areEqual(this.value, comparingMatcher.value)) {
            return false;
        }
        if (this.cmpFunc != comparingMatcher.cmpFunc) {
            return false;
        }
        return Intrinsics.areEqual(this.argumentType, comparingMatcher.argumentType);
    }
}

