/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonatype.nexus.client.core.subsystem.repository.GroupRepository;
import org.sonatype.nexus.client.core.subsystem.repository.RepositoryStatus;
import org.sonatype.nexus.client.internal.rest.jersey.subsystem.repository.JerseyRepository;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;
import org.sonatype.nexus.rest.model.RepositoryGroupMemberRepository;
import org.sonatype.nexus.rest.model.RepositoryGroupResource;
import org.sonatype.nexus.rest.model.RepositoryGroupResourceResponse;

public class JerseyGroupRepository<T extends GroupRepository>
extends JerseyRepository<T, RepositoryGroupResource, RepositoryStatus>
implements GroupRepository<T> {
    static final String REPO_TYPE = "group";
    static final String PROVIDER_ROLE = "org.sonatype.nexus.proxy.repository.GroupRepository";

    public JerseyGroupRepository(JerseyNexusClient nexusClient, String id) {
        super(nexusClient, id);
    }

    public JerseyGroupRepository(JerseyNexusClient nexusClient, RepositoryGroupResource resource) {
        super(nexusClient, resource);
    }

    @Override
    protected RepositoryGroupResource createSettings() {
        RepositoryGroupResource settings = new RepositoryGroupResource();
        settings.setRepoType(REPO_TYPE);
        settings.setProviderRole(PROVIDER_ROLE);
        settings.setExposed(true);
        return settings;
    }

    private T me() {
        return (T)this;
    }

    @Override
    String uri() {
        return "repo_groups";
    }

    @Override
    RepositoryGroupResource doGet() {
        try {
            return ((RepositoryGroupResourceResponse)((JerseyNexusClient)this.getNexusClient()).serviceResource(this.uri() + "/" + this.id()).get(RepositoryGroupResourceResponse.class)).getData();
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    @Override
    RepositoryGroupResource doCreate() {
        RepositoryGroupResourceResponse request = new RepositoryGroupResourceResponse();
        request.setData((RepositoryGroupResource)this.settings());
        try {
            return ((RepositoryGroupResourceResponse)((JerseyNexusClient)this.getNexusClient()).serviceResource(this.uri()).post(RepositoryGroupResourceResponse.class, (Object)request)).getData();
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    @Override
    RepositoryGroupResource doUpdate() {
        RepositoryGroupResourceResponse request = new RepositoryGroupResourceResponse();
        request.setData((RepositoryGroupResource)this.settings());
        try {
            return ((RepositoryGroupResourceResponse)((JerseyNexusClient)this.getNexusClient()).serviceResource(this.uri() + "/" + this.id()).put(RepositoryGroupResourceResponse.class, (Object)request)).getData();
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    @Override
    public List<String> memberRepositories() {
        List memberRepositories = ((RepositoryGroupResource)this.settings()).getRepositories();
        if (memberRepositories == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Lists.transform((List)memberRepositories, (Function)new Function<RepositoryGroupMemberRepository, String>(){

            public String apply(@Nullable RepositoryGroupMemberRepository member) {
                return member == null ? null : member.getId();
            }
        }));
    }

    @Override
    public T ofRepositories(String ... memberRepositoryIds) {
        Preconditions.checkNotNull((Object)memberRepositoryIds);
        this.ensureMemberListsIsValid();
        ((RepositoryGroupResource)this.settings()).getRepositories().clear();
        return this.addMember(memberRepositoryIds);
    }

    @Override
    public T addMember(String ... memberRepositoryIds) {
        this.ensureMemberListsIsValid();
        for (String memberRepositoryId : (String[])Preconditions.checkNotNull((Object)memberRepositoryIds)) {
            RepositoryGroupMemberRepository repository = new RepositoryGroupMemberRepository();
            repository.setId(memberRepositoryId);
            ((RepositoryGroupResource)this.settings()).addRepository(repository);
        }
        return this.me();
    }

    @Override
    public T removeMember(String ... memberRepositoryIds) {
        List<Object> toRemove = Arrays.asList((Object[])Preconditions.checkNotNull((Object)memberRepositoryIds));
        this.ensureMemberListsIsValid();
        Iterator it = ((RepositoryGroupResource)this.settings()).getRepositories().iterator();
        while (it.hasNext()) {
            if (!toRemove.contains(((RepositoryGroupMemberRepository)it.next()).getId())) continue;
            it.remove();
        }
        return this.me();
    }

    private void ensureMemberListsIsValid() {
        if (((RepositoryGroupResource)this.settings()).getRepositories() == null) {
            ((RepositoryGroupResource)this.settings()).setRepositories((List)Lists.newArrayList());
        }
    }
}

