/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.config;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.service.configuration.ConfigVetoableChangeListener;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.utils.logging2.LoggerImpl;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001c\u0010\u000b\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001c\u0010\u0011\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u0011\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0010H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u001eH\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0016H\u0016J\u0018\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\b\u0010%\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010&\u001a\u00020\u0010H\u0016J\b\u0010'\u001a\u00020\u0010H\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001c\u0010(\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0010H\u0016J\b\u0010,\u001a\u00020\fH\u0016J\u0012\u0010-\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0012\u0010.\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001c\u0010.\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001c\u0010/\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010/\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0012H\u0016J\u001e\u00100\u001a\u00020\f2\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020 \u0018\u000101H\u0016J\u001c\u00102\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u00103\u001a\u0004\u0018\u00010 H\u0016J$\u00102\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u00103\u001a\u0004\u0018\u00010 2\u0006\u00104\u001a\u00020\u0016H\u0016J\b\u00105\u001a\u00020\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u00066"}, d2={"Lorg/jitsi/config/AbstractReadOnlyConfigurationService;", "Lorg/jitsi/service/configuration/ConfigurationService;", "()V", "logger", "Lorg/jitsi/utils/logging2/LoggerImpl;", "getLogger", "()Lorg/jitsi/utils/logging2/LoggerImpl;", "properties", "Ljava/util/Properties;", "getProperties", "()Ljava/util/Properties;", "addPropertyChangeListener", "", "listener", "Ljava/beans/PropertyChangeListener;", "propertyName", "", "addVetoableChangeListener", "Lorg/jitsi/service/configuration/ConfigVetoableChangeListener;", "getAllPropertyNames", "", "getBoolean", "", "defaultValue", "getConfigurationFilename", "getDouble", "", "getInt", "", "getLong", "", "getProperty", "", "getPropertyNamesByPrefix", "prefix", "exactPrefixMatch", "getPropertyNamesBySuffix", "suffix", "getScHomeDirLocation", "getScHomeDirName", "getString", "logConfigurationProperties", "", "passwordPattern", "purgeStoredConfiguration", "removeProperty", "removePropertyChangeListener", "removeVetoableChangeListener", "setProperties", "", "setProperty", "property", "isSystem", "storeConfiguration", "jicoco-config"})
public abstract class AbstractReadOnlyConfigurationService
implements ConfigurationService {
    @NotNull
    private final LoggerImpl logger = new LoggerImpl(Reflection.getOrCreateKotlinClass(this.getClass()).getQualifiedName());

    @NotNull
    protected final LoggerImpl getLogger() {
        return this.logger;
    }

    @NotNull
    protected abstract Properties getProperties();

    @Nullable
    public String getString(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        Object object = this.getProperty(propertyName);
        return object != null && (object = object.toString()) != null ? ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString() : null;
    }

    @Nullable
    public String getString(@NotNull String propertyName, @Nullable String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        String string = this.getString(propertyName);
        if (string == null) {
            string = defaultValue;
        }
        return string;
    }

    public boolean getBoolean(@NotNull String propertyName, boolean defaultValue) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        String string = this.getString(propertyName);
        return string != null ? Boolean.parseBoolean(string) : defaultValue;
    }

    public double getDouble(@NotNull String propertyName, double defaultValue) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        String string = this.getString(propertyName);
        return string != null ? Double.parseDouble(string) : defaultValue;
    }

    public int getInt(@NotNull String propertyName, int defaultValue) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        String string = this.getString(propertyName);
        return string != null ? Integer.parseInt(string) : defaultValue;
    }

    public long getLong(@NotNull String propertyName, long defaultValue) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        String string = this.getString(propertyName);
        return string != null ? Long.parseLong(string) : defaultValue;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> getAllPropertyNames() {
        void $this$mapTo$iv$iv;
        Set<Object> set = this.getProperties().keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"properties.keys");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            if (v1 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            collection.add((String)v1);
        }
        return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
    }

    @Nullable
    public Object getProperty(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        Object object = this.getProperties().get(propertyName);
        if (object == null) {
            object = System.getProperty(propertyName);
        }
        return object;
    }

    @NotNull
    public List<String> getPropertyNamesByPrefix(@NotNull String prefix, boolean exactPrefixMatch) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        List matchingPropNames = new ArrayList();
        for (String name : this.getAllPropertyNames()) {
            if (exactPrefixMatch) {
                if (!Intrinsics.areEqual((Object)StringsKt.substringBeforeLast((String)name, (String)".", (String)""), (Object)prefix)) continue;
                ((Collection)matchingPropNames).add(name);
                continue;
            }
            if (!StringsKt.startsWith$default((String)name, (String)prefix, (boolean)false, (int)2, null)) continue;
            ((Collection)matchingPropNames).add(name);
        }
        return matchingPropNames;
    }

    public void logConfigurationProperties(@NotNull String passwordPattern) {
        Intrinsics.checkNotNullParameter((Object)passwordPattern, (String)"passwordPattern");
        Regex regex = new Regex(passwordPattern);
        Regex it = regex;
        boolean bl = false;
        Regex regex2 = ((CharSequence)passwordPattern).length() > 0 ? regex : null;
        for (String name : this.getAllPropertyNames()) {
            String value;
            if (this.getProperty(name) == null) continue;
            Regex regex3 = regex2;
            boolean bl2 = regex3 != null ? regex3.matches((CharSequence)name) : false;
            if (bl2) {
                value = "**********";
            }
            this.logger.info((Object)(name + " = " + value));
        }
    }

    @NotNull
    public String getConfigurationFilename() {
        throw new Exception("Unsupported");
    }

    @NotNull
    public String getScHomeDirLocation() {
        throw new Exception("Unsupported");
    }

    @NotNull
    public String getScHomeDirName() {
        throw new Exception("Unsupported");
    }

    @NotNull
    public Void addPropertyChangeListener(@Nullable PropertyChangeListener listener) {
        throw new Exception("Unsupported");
    }

    @NotNull
    public Void addPropertyChangeListener(@Nullable String propertyName, @Nullable PropertyChangeListener listener) {
        throw new Exception("Unsupported");
    }

    @NotNull
    public Void addVetoableChangeListener(@Nullable ConfigVetoableChangeListener listener) {
        throw new Exception("Unsupported");
    }

    @NotNull
    public Void addVetoableChangeListener(@Nullable String propertyName, @Nullable ConfigVetoableChangeListener listener) {
        throw new Exception("Unsupported");
    }

    @NotNull
    public Void removePropertyChangeListener(@Nullable PropertyChangeListener listener) {
        throw new Exception("Unsupported");
    }

    @NotNull
    public Void removePropertyChangeListener(@Nullable String propertyName, @Nullable PropertyChangeListener listener) {
        throw new Exception("Unsupported");
    }

    @NotNull
    public Void removeVetoableChangeListener(@Nullable ConfigVetoableChangeListener listener) {
        throw new Exception("Unsupported");
    }

    @NotNull
    public Void removeVetoableChangeListener(@Nullable String propertyName, @Nullable ConfigVetoableChangeListener listener) {
        throw new Exception("Unsupported");
    }

    @NotNull
    public Void purgeStoredConfiguration() {
        throw new Exception("Unsupported");
    }

    @NotNull
    public Void storeConfiguration() {
        throw new Exception("Unsupported");
    }

    @NotNull
    public Void setProperties(@Nullable Map<String, Object> properties) {
        throw new Exception("Unsupported");
    }

    @NotNull
    public Void setProperty(@Nullable String propertyName, @Nullable Object property) {
        throw new Exception("Unsupported");
    }

    @NotNull
    public Void setProperty(@Nullable String propertyName, @Nullable Object property, boolean isSystem) {
        throw new Exception("Unsupported");
    }

    @NotNull
    public Void removeProperty(@Nullable String propertyName) {
        throw new Exception("Unsupported");
    }

    @NotNull
    public List<String> getPropertyNamesBySuffix(@Nullable String suffix) {
        throw new Exception("Unsupported");
    }
}

