;;;; -*- Mode: Lisp; Syntax: ANSI-Common-Lisp; Base: 10 -*-
;;;; *************************************************************************
;;;; FILE IDENTIFICATION
;;;;
;;;; Name:          hyperobject.asd
;;;; Purpose:       ASDF system definition for hyperobject package
;;;; Author:        Kevin M. Rosenberg
;;;; Date Started:  Apr 2000
;;;;
;;;; $Id$
;;;; *************************************************************************

(defpackage hyperobject-system (:use #:asdf #:cl))
(in-package :hyperobject-system)

(defsystem hyperobject
  :name "hyperobject"
  :author "Kevin M. Rosenberg <kevin@rosenberg.net>"
  :version "2.7.2"
  :maintainer "Kevin M. Rosenberg <kmr@debian.org>"
  :licence "BSD-like License"
  :depends-on (:kmrcl :clsql)
  :components
  ((:file "package")
   (:file "metaclass" :depends-on ("package"))
   (:file "mop" :depends-on ("metaclass"))
   (:file "rules" :depends-on ("mop"))
   (:file "connect" :depends-on ("mop"))
   (:file "sql" :depends-on ("connect"))
   (:file "views" :depends-on ("mop"))
   (:file "base-class" :depends-on ("views" "sql" "rules"))
   )
  :in-order-to ((test-op (test-op "hyperobject/test"))))

(defsystem hyperobject/test
    :depends-on (:rt :hyperobject)
    :components ((:file "tests"))
    :perform (test-op (o s)
                      (or (funcall (intern (symbol-name '#:do-tests)
                                           (find-package '#:regression-test)))
                          (error "test-op failed"))))
