/* do_echo.c - do_echo */

#include <sys/types.h>
#include <sys/ioctl.h>

#include <stdio.h>

#include "telnet.h"

char		doecho;		/* nonzero, if remote ECHO	*/
extern u_char	option_cmd;

/*------------------------------------------------------------------------
 * do_echo - handle telnet will/won't ECHO option
 *------------------------------------------------------------------------
 */
int
do_echo(sfp, tfp, c)
FILE    *sfp, *tfp;
int     c;
{
        struct sgttyb   ttyb;
	int		ok, tfd = fileno(tfp);

	if (doecho) {
		if (option_cmd == TCWILL)
			return 0;	/* already doing ECHO		*/
	} else if (option_cmd == TCWONT)
		return 0;		/* already NOT doing ECHO	*/

        if (ok = ioctl(tfd, TIOCGETP, (char *)&ttyb) == 0) {
        	if (option_cmd == TCWILL) {
              	 	ttyb.sg_flags &= ~ECHO;
			ttyb.sg_flags |= CBREAK;
		} else {
			ttyb.sg_flags |= ECHO;
			ttyb.sg_flags &= ~CBREAK;
		}
                ok &= ioctl(tfd, TIOCSETP, (char *)&ttyb) == 0;
        }
	if (ok)
		doecho = !doecho;
        (void) putc(TCIAC, sfp);
        if (doecho)
                (void) putc(TCDO, sfp);
        else
                (void) putc(TCDONT, sfp);
	(void) putc((char)c, sfp);
	return 0;
}
