/* scrinit.c - scrinit */

#include <stdio.h>

#include "telnet.h"
#include "local.h"

extern int		scrindex;
extern struct ttystate	tntty;

/*------------------------------------------------------------------------
 * scrinit - initialize tty modes for script file collection
 *------------------------------------------------------------------------
 */
/*ARGSUSED*/
int
scrinit(sfp, tfp, c)
FILE	*sfp, *tfp;
int	c;
{
	struct ttystate	newtty;

	if (!doecho) {
		fprintf(tfp, "\nscripting requires remote ECHO.\n");
		return -1;
	}
	if (scrfp) {
		fprintf(tfp,"\nalready scripting to \"%s\".\n", scrname);
		return -1;
	}
	scrindex = 0;
	ttysave(&tntty);		/* save current tty settings	*/

	newtty = oldtty;
	newtty.ts_tchars.t_intrc = -1;		/* disable interrupt	*/
	newtty.ts_tchars.t_quitc = -1;		/* disable interrupt	*/
	newtty.ts_ltchars.t_suspc = -1;		/* disable suspend	*/
	newtty.ts_ltchars.t_dsuspc = -1;	/* disable suspend	*/
	ttyrestore(&newtty);

	fprintf(tfp, "\nscript file: ");
	(void) fflush(tfp);
	return 0;
}
