/* ttysetup.c - ttysetup */

#include <stdio.h>

#include "local.h"

/*------------------------------------------------------------------------
 * ttysetup - set up tty
 *------------------------------------------------------------------------
 */
int
ttysetup()
{
	extern struct ttystate	tntty;

	ttysave(&oldtty);	/* save original tty state	*/

	sg_erase = oldtty.ts_sgttyb.sg_erase;
	sg_kill = oldtty.ts_sgttyb.sg_kill;
	t_intrc = oldtty.ts_tchars.t_intrc;
	t_quitc = oldtty.ts_tchars.t_quitc;
	t_flushc = oldtty.ts_ltchars.t_flushc;

	tntty = oldtty;

	/* disable some special characters */
	tntty.ts_tchars.t_intrc = -1;
	tntty.ts_tchars.t_quitc = -1;
	tntty.ts_ltchars.t_suspc = -1;
	tntty.ts_ltchars.t_dsuspc = -1;

	ttyrestore(&tntty);
}
