/****  cbdialog.h  ****  declarations for a simple dialog box  ****/

/********************************************************************
*  Copyright (c) 1990 Iris Computing Laboratories.
*
*  This software is provided for demonstration purposes only.  As
*  freely-distributed, modifiable source code, this software carries
*  absolutely no warranty.
********************************************************************/


#ifndef CBDIALOGH
#define CBDIALOGH	1


#include "simplewin.h"


#define BUTTON_BORDER_WIDTH		2
#define EOB						-1


/*
The client can allocate an array of "buttons" to specify
the buttons for a dialog box.  The array should be NULL-
terminated.  If the button with the callback procedure
stored in "callback" is selected, the callback procedure
is executed.
*/

typedef void (*ptr_void_proc)();

typedef struct {
	char *label;
	ptr_void_proc callback;
} button;


typedef struct {
	Window bid;
	Window parent;
	char *label;
	ptr_void_proc callback;	/* (ptr. to) procedure to	*/
							/* execute upon selection	*/
	int x, y;				/* relative to parent */
	unsigned int width, height;
} lbutton;



extern int make_dialog_buttons();
extern int dialog_loop();
extern void display_buttons();
extern void highlight_button();
extern void unhighlight_button();
extern void cleanup_dialog_structures();


#endif
