/****  cbrespbox.h  **** declarations for cbrespbox.c  ****/

/********************************************************************
*  Copyright (c) 1990 Iris Computing Laboratories.
*
*  This software is provided for demonstration purposes only.  As
*  freely-distributed, modifiable source code, this software carries
*  absolutely no warranty.
********************************************************************/


#ifndef CBRESPBOXH
#define CBRESPBOXH	1


/*
The response box is built on top of the simplewin.[ch] and
cbdialog.[ch] modules.  It provides routines to read a
string response from the user, in addition to the button
support provided by the cbdialog.[ch] module.
See simplewin.[ch] and cbdialog.[ch].

The user can distinguish among responses as follows:
	responsebox_loop() returns:		meaning
	------------------------		-------
	KEY_RESPONSE					normal response -- the string
									has been null-terminated
	ESC_KEY							user pressed <ESC> key
	otherwise						user pressed a button w/o
									entering text

A return value of KEY_RESPONSE means that you can safely use
the string response, although it may have a length of zero.
The user pressed either <Enter> or a button after text entry.

NOTE:  The significance of a selected button MUST be detected
via the callback functions.

NOTE:  A button-associated callback function will be executed
ONLY if a button is selected; typing text and pressing <Enter>
simply returns KEY_RESPONSE with a null-terminated string.
*/


#include <X11/cursorfont.h>
#include "simplewin.h"


#define TRUE                1           /* logical constants */
#define FALSE               0

#define EOS                 '\0'        /* special characters */
#define LF                  '\n'
#define TAB                 '\t'
#define BKSP                '\b'
#define BLANK               ' '
#define ESC                 27


#define MAX_STR				80
#define NO_KEY_NO_BUTTON	-1
#define KEY_RESPONSE		-2
#define ESC_KEY				-3


/*
Functions:
*/

extern void initialize_responsebox_structures();
extern void cleanup_responsebox_structures();
extern int responsebox_loop();
extern void window_puts_point();
extern int window_gets_filter();
extern int window_getche_event_loop();

#endif

