/****  testrespbox.c  ****  tests the callback response box  ****/


#include <stdio.h>
#include <string.h>

#include "cbdialog.h"
#include "cbrespbox.h"


/*
Functions:
*/

void main(), cleanup_resources();
void cb_france(), cb_arctic(), cb_retire();


/*
Private globals:
*/

static char codename[MAX_STR];	/* secret! */


/*
main() exercises the response box.
*/

void main(argc, argv)
int argc;
char *argv[];
{
	static button buttons[] = {
		{"South of France", cb_france},
		{"North Pole", cb_arctic},
		{"Early Retirement", cb_retire},
		{NULL, NULL},
	};
	logical_window_frame lwindow, *lwin = &lwindow;
	XSizeHints test_size_hints;
	XFontStruct *font;
	char *application_name = "testcbrespbox";
	int result;

	init_display(application_name);
	load_font(&font, application_name, "8x13");
	initialize_responsebox_structures(font);
	test_size_hints.min_width = 53 * font->max_bounds.width;
	test_size_hints.min_height =
		7 * (font->max_bounds.ascent + font->max_bounds.descent);
	make_window(RootWindow(display, screen), lwin, 0, 0,
		53, 7, 1, &test_size_hints, font);
	XSetStandardProperties(display, lwin->xwin, application_name,
		application_name, None, argv, argc, &test_size_hints);
	if (!make_dialog_buttons(lwin, buttons)) {
		fprintf(stderr, "%s: can't create window buttons!\n",
			application_name);
		exit(-1);
	}
	result = responsebox_loop(lwin, "Mission:  Impossible",
		"Codename: ", codename);
	if (result == ESC_KEY)
		fprintf(stdout, "Mission canceled.\n");
	else
		/* ignore other non-button-initiated activities */;
	cleanup_resources(lwin, font);
	exit(0);
}   /* main */


/*
cleanup_resources() performs an orderly clean-up.
*/

void cleanup_resources(lwin, font)
logical_window_frame *lwin;
XFontStruct *font;
{
	cleanup_dialog_button_structures(lwin);
	cleanup_responsebox_structures();
	cleanup_window(lwin);
	XUnloadFont(display, font->fid);
	XCloseDisplay(display);
}	/* cleanup_resources */


/*
Mission Impossible callbacks.
*/

void cb_france()
{
	if (strcmp(codename, "fun and sun") != 0) {
		fprintf(stdout,
			"Invalid codename -- mission canceled.\n");
		return;
	}
	fprintf(stdout,
	"As always, if you're discovered, we'll deny everything.\n");
}	/* cb_france */


void cb_arctic()
{
	if (strcmp(codename, "frozen tundra") != 0) {
		fprintf(stdout,
			"Invalid codename -- mission canceled.\n");
		return;
	}
	fprintf(stdout,
	"As always, if you're discovered, we'll deny everything.\n");
}	/* cb_arctic */


void cb_retire()
{
	fprintf(stdout, "A secret agent can never retire...\n");
}	/* cb_retire */

