/****  response.c  ****  interface for a high-level response box ****/


/*
This module provide a three-function inteface to response boxes.
Operationally, it provides a high-level interface to cbrespbox.[ch].
Also, it supports the creation of multiple response boxes.
*/


#include "response.h"


/*
response_create() creates and returns a pointer to a response box.
Multiple response boxes can be created; in this implementation,
they share the same font.
*/

Response response_create(row_width, row_height, border_width,
	buttons, app_name, font, argv, argc)
unsigned int row_width, row_height, border_width;
button *buttons;
char *app_name;
XFontStruct *font;
char *argv[];
int argc;
{
	static int common_structures_already_created = FALSE;
	XSizeHints size_hints;
	Response response;

	response = (Response) malloc(sizeof(_Response));
	if (response == NULL) {
		fprintf(stderr, "%s: can't allocate response box.\n",
			app_name);
		return NULL;
	}
	if (!common_structures_already_created) {
		common_structures_already_created = TRUE;
		initialize_responsebox_structures(font);
	}
	size_hints.min_width = row_width * font->max_bounds.width;
	size_hints.min_height = row_height *
		(font->max_bounds.ascent + font->max_bounds.descent);
	make_window(RootWindow(display, screen), &response->lwindow, 0, 0,
		row_width, row_height, border_width, &size_hints, font);
	XSetStandardProperties(display, response->lwindow.xwin,
		app_name, app_name, None, argv, argc, &size_hints);
	if (!make_dialog_buttons(&response->lwindow, buttons)) {
		fprintf(stderr, "%s: can't create window buttons!\n",
			app_name);
		return NULL;
	}
	response->self = response;			/* self-reference pointer	*/
	return (Response) response->self;	/* for free() operations	*/
}   /* response_create */


/*
Operationally, response_loop() is the same as responsebox_loop()
from the lower level module; it is provided for consistency
of protocol.
*/

int response_loop(response, title, prompt, response_return_string)
Response response;
char *title, *prompt, *response_return_string;
{
	return responsebox_loop(&response->lwindow, title,
		prompt, response_return_string);
}	/* response_loop */


/*
response_cleanup() frees response box structures.
*/

void response_cleanup(response)
Response response;
{
	static int common_structures_already_freed = FALSE;

	cleanup_dialog_button_structures(&response->lwindow);
	if (!common_structures_already_freed) {
		common_structures_already_freed = TRUE;
		cleanup_responsebox_structures();
	}
	cleanup_window(&response->lwindow);
	free(response->self);
}	/* response_cleanup */


