/****  testresponse.c  ****  tests the high-level response box  ****/


#include "response.h"


/*
Functions:
*/

void main();
void print_response(), print_cancel();


/*
Private globals:
*/

static char *str_response;
static int cancel = FALSE;


/*
main() exercises the response boxes.
*/

void main(argc, argv)
int argc;
char *argv[];
{
	static button respbox_btns[] = {
		{"Apply", print_response},
		{"Cancel", print_cancel},
		{NULL, NULL},
	};
	Response respbox1, respbox2;
	XFontStruct *font;
	char *application_name = "testresponse";
	int result1, result2;
	char first_name[MAX_STR], last_name[MAX_STR];

	init_display(application_name);
	load_font(&font, application_name, "8x13");
	respbox1 = response_create(53, 7, 1, respbox_btns,
		application_name, font, argv, argc);
	respbox2 = response_create(53, 7, 1, respbox_btns,
		application_name, font, argv, argc);
	str_response = first_name;		/* used by print_response() */
	result1 = response_loop(respbox1, "Response Box 1",
		"What is your first name: ", first_name);
	if (!(cancel || result1 == ESC_KEY)) {
		str_response = last_name;	/* used by print_response() */
		result2 = response_loop(respbox2, "Response Box 2",
			"What is your last name: ", last_name);
		if (!(cancel || result2 == ESC_KEY)) {
			if (result1 == KEY_RESPONSE && result2 == KEY_RESPONSE)
				printf("Goodbye, %s %s.\n", first_name, last_name);
		}
		else
			printf("Response box terminated.\n");
	}
	else
		printf("Response box terminated.\n");
	response_cleanup(respbox1);
	response_cleanup(respbox2);
	XUnloadFont(display, font->fid);
	XCloseDisplay(display);
	exit(0);
}   /* main */


void print_response()
{
	printf("You typed: %s.\n", str_response);
}	/* print_response */


void print_cancel()
{
	printf("Response box cancelled.\n");
	cancel = TRUE;
}	/* print_cancel */
