/****  dialog.h  ****  declarations for a simple dialog box  ****/

/********************************************************************
*  Copyright (c) 1990 Iris Computing Laboratories.
*
*  This software is provided for demonstration purposes only.  As
*  freely-distributed, modifiable source code, this software carries
*  absolutely no warranty.
********************************************************************/


#ifndef DIALOGH
#define DIALOGH	1


#include "simplewin.h"


#define BUTTON_BORDER_WIDTH		2
#define EOB						-1


/*
The client can allocate an array of "buttons" to specify
the buttons for a dialog box.  The array should be NULL-
terminated.  If the button with the label value stored in
"label" is selected, the value of "value" is returned.
"value" MUST BE POSITIVE.
*/

typedef struct {
	char *label;
	int value;
} button;


typedef struct {
	Window bid;
	Window parent;
	char *label;
	int value;		/* value returned when a button selected */
	int x, y;		/* relative to parent */
	unsigned int width, height;
} lbutton;


/*
Functions:
*/

extern int make_dialog_buttons();
extern int dialog_loop();
extern void cleanup_dialog_structures();
extern void display_buttons();
extern void highlight_button();
extern void unhighlight_button();


#endif
