/****  testdialog.c  ****  tests a simple dialog box  ****/


#include <stdio.h>
#include <string.h>

#include "simplewin.h"
#include "dialog.h"


/*
Functions:
*/

void main(), cleanup_resources();


/*
main() initializes the display, creates the dialog box
and tests the returned value.
*/

void main(argc, argv)
int argc;
char *argv[];
{
	static button buttons[] = {
		{"Button One", 1},
		{"Button Two", 2},
		{"Button Three", 3},
		{NULL, NULL},
	};
	logical_window_frame lwindow, *lwin = &lwindow;
	XSizeHints test_size_hints;
	XFontStruct *font;
	char *application_name = "testdialog";
	int button_result;

	init_display(application_name);
	load_font(&font, application_name, "8x13");
	initialize_window_structures(font);
	test_size_hints.min_width = 47 * font->max_bounds.width;
	test_size_hints.min_height =
		7 * (font->max_bounds.ascent + font->max_bounds.descent);
	make_window(RootWindow(display, screen), lwin, 0, 0,
		47, 7, 1, &test_size_hints, font);
	XSetStandardProperties(display, lwin->xwin, application_name,
		application_name, None, argv, argc, &test_size_hints);
	if (!make_dialog_buttons(lwin, buttons)) {
		fprintf(stderr, "%s: can't create window buttons!\n",
			application_name);
		exit(-1);
	}
	button_result = dialog_loop(lwin,
		"This is the test window.",
		"Press a button.");
	fprintf(stdout, "You pressed button: %d\n", button_result);
	cleanup_resources(lwin, font);
	exit(0);
}   /* main */


/*
cleanup_resources() performs an orderly clean-up.
*/

void cleanup_resources(lwin, font)
logical_window_frame *lwin;
XFontStruct *font;
{
	cleanup_dialog_button_structures(lwin);
	cleanup_window_structures();
	cleanup_window(lwin);
	XUnloadFont(display, font->fid);
	XCloseDisplay(display);
}	/* cleanup_resources */

