/****  testresponse.c  ****  tests the response box  ****/


#include <stdio.h>
#include <string.h>

#include "dialog.h"
#include "response.h"



#define APPLY	1				/* button responses */
#define CANCEL	2



/*
Functions:
*/

void main(), cleanup_resources();



/*
main() initializes the display, creates the response box
(window), and acts on the returned value;
*/

void main(argc, argv)
int argc;
char *argv[];
{
	static button buttons[] = {		/* positive values only */
		{"Apply", APPLY},
		{"Cancel", CANCEL},
		{NULL, NULL},
	};
	logical_window_frame lwindow, *lwin = &lwindow;
	XSizeHints test_size_hints;
	XFontStruct *font;
	char *application_name = "testresponse";
	char filename[MAX_STR];
	int result;

	init_display(application_name);
	load_font(&font, application_name, "8x13");
	initialize_responsebox_structures(font);
	test_size_hints.min_width = 47 * font->max_bounds.width;
	test_size_hints.min_height =
		7 * (font->max_bounds.ascent + font->max_bounds.descent);
	make_window(RootWindow(display, screen), lwin, 0, 0,
		47, 7, 1, &test_size_hints, font);
	XSetStandardProperties(display, lwin->xwin, application_name,
		application_name, None, argv, argc, &test_size_hints);
	if (!make_dialog_buttons(lwin, buttons)) {
		fprintf(stderr, "%s: can't create window buttons!\n",
			application_name);
		exit(-1);
	}
	result = responsebox_loop(lwin, "File Print Facility",
		"Filename: ", filename);
	if (result == CANCEL || result == ESC_KEY)
		fprintf(stdout, "Print canceled.\n");
	else if (!strlen(filename))
		fprintf(stdout, "Invalid filename; print canceled.\n");
	else
		fprintf(stdout, "Print simulation for file: %s\n", filename);
	cleanup_resources(lwin, font);
	exit(0);
}   /* main */


/*
cleanup_resources() performs an orderly clean-up.
*/

void cleanup_resources(lwin, font)
logical_window_frame *lwin;
XFontStruct *font;
{
	cleanup_dialog_button_structures(lwin);
	cleanup_responsebox_structures();
	cleanup_window(lwin);
	XUnloadFont(display, font->fid);
	XCloseDisplay(display);
}	/* cleanup_resources */

