/****  display.c  ****  X text display routines  ****/


#include "screen.h"
#include "display.h"


#define BLANK       ' '



/*
display_string() displays a string in a window.
*/

void display_string(display, drawable, gc, x, y, str)
Display *display;
Drawable drawable;
GC gc;
int x, y;
char *str;
{
	XDrawImageString(display, drawable, gc, x, y, str, strlen(str));
}   /* display_string */


/*
display_char() displays a character in a window.
*/

void display_char(display, drawable, gc, x, y, ch)
Display *display;
Drawable drawable;
GC gc;
int x, y;
char ch;
{
	char str[2];

	str[0] = ch;
	str[1] = '\0';
	XDrawImageString(display, drawable, gc, x, y, str, 1);
}   /* display_string */

