/****  screen.c  ****  screen handling routines  ****/


#include "screen.h"


/*
globals:
*/

Display *display;
Screen *screen_ptr;
int screen;
unsigned int display_width, display_height, display_depth;


void init_display(application_name)
char *application_name;
{
	char *display_name = NULL;

	if ((display = XOpenDisplay(display_name)) == NULL) {
		(void) fprintf(stderr,
			"%s: cannot connect to X server %s\n",
			application_name, XDisplayName(display_name));
			exit(-1);
	}
	screen_ptr = display->screens;
	screen = DefaultScreen(display);

	display_width = DisplayWidth(display, screen);
	display_height = DisplayHeight(display, screen);
	display_depth = DisplayPlanes(display, screen);
}   /* init_display */


/*
load_font() loads the specified font, printing a message to
stderr in the event of an error.
*/

void load_font(font_info, application_name, font_name)
XFontStruct **font_info;
char *application_name;
char *font_name;
{
	if ((*font_info = XLoadQueryFont(display, font_name))
			== NULL) {
		(void) fprintf(stderr, "%s: cannot open %s font\n",
			application_name, font_name);
		exit(-1);
	}
}   /* load_font */

