/****    simplewin.h    ****/


#ifndef SIMPLEWINH
#define SIMPLEWINH	1


#include <X11/cursorfont.h>
#include "screen.h"
#include "display.h"


#define TRUE                1           /* logical constants */
#define FALSE               0
#define CANT_ALLOCATE_WIN   -99

#define EOS                 '\0'        /* special characters */
#define LF					'\n'

#define REVERSE				0
#define NORMAL				1



typedef struct {
	Window xwin;		/* the associated X window */
	void *extension;	/* pointer to whatever, e.g, buttons */
	XFontStruct *font;
	XSizeHints *size_hints;
	int cursor_x;
	int cursor_y;
	int font_height, font_width;
	unsigned int width, height, trunc_height;
	int is_active;
} logical_window_frame;



/*
Globals:
*/

extern GC gc, rgc, hgc;
extern Cursor popup_cursor;



/*
Functions:
*/

extern void initialize_window_structures();
extern void cleanup_window_structures(); 
extern void make_window();
extern void cleanup_window(); 
extern void set_up_GC();
extern void make_popup_cursor();
extern void activate_window();
extern void deactivate_window();
extern void window_puts();
extern void window_puts_center();
extern int window_puts_by_char();
extern void window_puts_lf();
extern int window_putchar();
extern void window_clr_eol();
extern void window_display_header();
extern void window_reverse_row();
extern int window_go_xy();
extern int window_go_cr();
extern void window_clr_rest();
extern void window_cursor_bottom();
extern int r_pos();
extern int c_pos();
extern int last_row();
extern int last_col();
extern int get_keystroke();


#endif

