/****  respbox.c  ****  a simple, variable-button response box  ****/

/*
Design:
	- create response box with response_create()
	- add buttons with response_add_buttons()
	- clean up structures with response_cleanup()
	- query user with response_query()
	- the value returned from get_response_result is the number of
	  the selected button -- the first button is button 1
	- currently designed for one response box only
*/


#include "respbox.h"


/*
Private functions:
*/

static void ResponseBox();


/*
Private globals:
*/

static int response_created = FALSE;	/* explicit init as	*/
										/* reminder			*/

static Widget responseBox, responseButtonBox, responseInsideBox,
	responseLabel;

static int query_result;		/* holds the result of	*/
								/* a response box query	*/
static int query_wait;			/* controls the blocking		*/
								/* activity of a response box	*/

static Widget box_parent;		/* for reference only; used	*/
								/* with XtDisplay(...),		*/
								/* XtWindow(...), etc.		*/

static int num_buttons = 0;		/* button variables */
static int max_buttons = 0;
static Widget *buttons;



/*
response_create() creates a yes-no, two-button response box.
It returns FALSE in the event of an error.
*/

int response_create(parent, max_num_btns)
Widget parent;
int max_num_btns;
{
	Arg args[15];
	int i;

	if (response_created) {		/* currently supports one box */
		fprintf(stderr, "Response box already exists!\n");
		return FALSE;
	}
	response_created = TRUE;
	box_parent = parent;
	max_buttons = max_num_btns;
	buttons = (Widget *)
		XtMalloc((unsigned) (max_buttons) * sizeof(Widget *));
	if (buttons == NULL) {
		fprintf(stderr, "Can't allocate memory for buttons!\n");
		return FALSE;
	}
	i = 0;
	XtSetArg(args[i], XmNdialogTitle,
		XmStringCreateLtoR("ResponseBox",
			XmSTRING_DEFAULT_CHARSET)); i++;
	XtSetArg(args[i], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL); i++;
	XtSetArg(args[i], XmNnoResize, (XtArgVal) TRUE); i++;
	XtSetArg(args[i], XmNresizePolicy, (XtArgVal) XmRESIZE_ANY); i++;
	responseBox = XmCreateBulletinBoardDialog(parent,
		"responseBox", args, i);
	i = 0;
	XtSetArg(args[i], XmNborderWidth, (XtArgVal) 0); i++;
	XtSetArg(args[i], XmNorientation, (XtArgVal) XmVERTICAL); i++;
	responseInsideBox = XtCreateManagedWidget("responseInsideBox",
		xmRowColumnWidgetClass, responseBox, args, i);
	i = 0;
	XtSetArg(args[i], XmNlabelType, (XtArgVal) XmSTRING); i++;
	XtSetArg(args[i], XmNborderWidth, (XtArgVal) 0); i++;
	XtSetArg(args[i], XmNx, (XtArgVal) 0); i++;
	XtSetArg(args[i], XmNy, (XtArgVal) 0); i++;
	responseLabel = XtCreateManagedWidget("responseLabel",
		xmLabelWidgetClass, responseInsideBox, args, i);
	i = 0;
	XtSetArg(args[i], XmNborderWidth, (XtArgVal) 0); i++;
	XtSetArg(args[i], XmNorientation, (XtArgVal) XmHORIZONTAL); i++;
	responseButtonBox = XtCreateManagedWidget("responseButtonBox",
		xmRowColumnWidgetClass, responseInsideBox, args, i);
	return TRUE;
}	/* response_create */


/*
response_add_button() adds buttons to the response box. It
returns the number of the button added, or FALSE/0 if the
limit is reached.
*/

int response_add_button(name, label)
char *name;
char *label;
{
	Arg args[5];
	int i;

	if (num_buttons == max_buttons) {
		fprintf(stderr,
			"Maximum number of buttons already allocated!\n");
		return FALSE;
	}
	i = 0;
	XtSetArg(args[i], XmNlabelString,
		XmStringCreateLtoR(label, XmSTRING_DEFAULT_CHARSET)); i++;
	buttons[num_buttons] = XtCreateManagedWidget(name,
		xmPushButtonWidgetClass, responseButtonBox, args, i);
	XtAddCallback(buttons[num_buttons], XmNactivateCallback,
		ResponseBox, NULL);
	return ++num_buttons;
}	/* response_add_button */


/*
response_cleanup() frees dynamic data structures.
*/

void response_cleanup()
{
	if (buttons != NULL)
		XtFree(buttons);
}	/* response_cleanup */


/*
ResponseBox() determines which option has been selected
in a dialog window and resets the `wait' variable; it works
with response_query().
*/
/*ARGSUSED*/
static void ResponseBox(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	int i;

	XtUnmanageChild(responseBox);
	for (i = 0; i < num_buttons; i++)
		if (w == buttons[i]) {
			query_result = i + 1;		/* non-zero-based */
			query_wait = FALSE;
			return;
		}
	query_result = FALSE;
	query_wait = FALSE;
}	/* ResponseBox */


/*
get_response_result() is a pop-up window function for waiting
on the user's selection to the yes-no response query.
*/

int get_response_result()
{
	XEvent event;

	query_wait = TRUE;				/* block until the user	*/
	while (query_wait) {			/* presses a button		*/
		XtNextEvent(&event);
		XtDispatchEvent(&event);
	}
	return query_result;
}	/* get_response_result */


/*
response_query() pops up a dialog window; it works with
ResponseBox().  The response box is positioned at the cursor.
*/

void response_query(message)
char *message;
{
	Arg args[3];
	int i;
	Window dummy_w;
	int root_x, root_y, dummy_xy;
	unsigned int dummy_keys;

	XQueryPointer(XtDisplay(box_parent),
		XtWindow(box_parent), &dummy_w, &dummy_w, &root_x,
		&root_y, &dummy_xy, &dummy_xy, &dummy_keys);
	i = 0;
	XtSetArg(args[i], XmNx, (XtArgVal) (root_x - 20)); i++;
	XtSetArg(args[i], XmNy, (XtArgVal) (root_y - 20)); i++;
	XtSetValues(responseBox, args, i);/*****  fix this!! ****/
	i = 0;
	XtSetArg(args[i], XmNlabelString,
		XmStringCreateLtoR(message, XmSTRING_DEFAULT_CHARSET)); i++;
	XtSetValues(responseLabel, args, i);
	XtManageChild(responseBox);
}	/* response_query */

