/**  testrespbox.c  **  tests the variable-button response box  **/


#include "respbox.h"



#define EXIT_BTN	1			/* button values */
#define CANCEL_BTN	2


/*
Functions:
*/

void main(), create_main_buttons();
void Quit(), TestButtons();


/*
Private Widgets:
*/

static Widget topLevel, buttonBox, buttonTest, buttonQuit;


/*
main() manages a simple demonstration of a two-button,
blocking response box.
*/

void main(argc, argv)
int argc;
char *argv[];
{
	topLevel = XtInitialize(argv[0], "TestResponse", NULL, 0,
		&argc, argv);

	create_main_buttons(topLevel);
	response_create(topLevel, 2);			/* no error checks */
	response_add_button("exitButton", "Exit");
	response_add_button("cancelButton", "Cancel");
	
	XtRealizeWidget(topLevel);
	XtMainLoop();
}	/* main */


/*
create_main_buttons() sets up the buttonbox, its buttons,
and their callbacks.
*/

void create_main_buttons(parent)
Widget parent;
{
	Arg args[5];
	int i;

	i = 0;
	XtSetArg(args[i], XmNorientation, (XtArgVal) XmHORIZONTAL); i++;
	XtSetArg(args[i], XmNentryAlignment,
		(XtArgVal) XmALIGNMENT_CENTER); i++;
	buttonBox = XtCreateManagedWidget("buttonBox",
		xmRowColumnWidgetClass, parent, args, i);
	i = 0;
	XtSetArg(args[i], XmNlabelString,
		XmStringCreateLtoR("Quit",
			XmSTRING_DEFAULT_CHARSET)); i++;
	buttonQuit = XtCreateManagedWidget("buttonQuit",
		xmPushButtonWidgetClass, buttonBox, args, i);
	XtAddCallback(buttonQuit, XmNactivateCallback, Quit, NULL);
	i = 0;
	XtSetArg(args[i], XmNlabelString,
		XmStringCreateLtoR("Test Buttons",
			XmSTRING_DEFAULT_CHARSET)); i++;
	buttonTest = XtCreateManagedWidget("buttonTest",
		xmPushButtonWidgetClass, buttonBox, args, i);
	XtAddCallback(buttonTest, XmNactivateCallback, TestButtons, NULL);
}	/* create_main_buttons */


/*
Quit() terminates the application.
*/
/*ARGSUSED*/
void Quit(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	response_cleanup();
	exit(0);
}	/* Quit */


/*
TestButtons() activates the response box.
*/
/*ARGSUSED*/
void TestButtons(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	response_query("Would you like to exit?");
	if (get_response_result() == EXIT_BTN) {
		response_query("Confirm exit!");
		if (get_response_result() == EXIT_BTN) {
			printf("Application terminated.\n");
			response_cleanup();
			exit(0);
		}
		else
			printf("Application NOT terminated.\n");
	}
	else
		printf("Application NOT terminated.\n");
}	/* TestButtons */

