/****    alert.c    ****    simple alert box implementation    ****/


#include "alert.h"


/*
Private globals:
*/

static Widget alertYesNoCancel, alertContinue,
	alertButtonContinue, alertLabelContinue;


static int query_result;		/* holds the result of	*/
								/* an alert box query	*/
static int query_wait;			/* controls the blocking	*/
								/* activity of an alert box	*/


/*
alert_create_ync() creates a yes-no-cancel, three-button alert box.
*/

void alert_create_ync(parent)
Widget parent;
{
	Arg args[15];
	int i;
	static XtCallbackRec cb_list[] = {
		{AlertYesNoCancel, (caddr_t) NULL},
		{(XtCallbackProc) NULL, (caddr_t) NULL},
	};

	i = 0;
	XtSetArg(args[i], XmNdialogTitle,
		XmStringCreateLtoR("Alert",
			XmSTRING_DEFAULT_CHARSET)); i++;
	XtSetArg(args[i], XmNdialogStyle,
		XmDIALOG_APPLICATION_MODAL); i++;
	XtSetArg(args[i], XmNokLabelString,
		XmStringCreateLtoR("Yes", XmSTRING_DEFAULT_CHARSET)); i++;
	XtSetArg(args[i], XmNokCallback, cb_list); i++;
	XtSetArg(args[i], XmNcancelLabelString,
		XmStringCreateLtoR("No", XmSTRING_DEFAULT_CHARSET)); i++;
	XtSetArg(args[i], XmNcancelCallback, cb_list); i++;
	XtSetArg(args[i], XmNhelpLabelString,
		XmStringCreateLtoR("Cancel",
			XmSTRING_DEFAULT_CHARSET)); i++;
	XtSetArg(args[i], XmNhelpCallback, cb_list); i++;
	XtSetArg(args[i], XmNnoResize, (XtArgVal) TRUE); i++;
	XtSetArg(args[i], XmNresizePolicy,
		(XtArgVal) XmRESIZE_ANY); i++;
	alertYesNoCancel = XmCreateQuestionDialog(parent,
		"alertYesNoCancel", args, i);
}	/* alert_create_ync */


/*
alert_create_continue() creates a one-button alert box.
*/

void alert_create_continue(parent)
Widget parent;
{
	Arg args[10];
	int i;

	i = 0;
	XtSetArg(args[i], XmNdialogTitle,
		XmStringCreateLtoR("Alert",
			XmSTRING_DEFAULT_CHARSET)); i++;
	XtSetArg(args[i], XmNdialogStyle,
		XmDIALOG_APPLICATION_MODAL); i++;
	XtSetArg(args[i], XmNallowOverlap, (XtArgVal) FALSE); i++;
	XtSetArg(args[i], XmNautoUnmanage, (XtArgVal) TRUE); i++;
	XtSetArg(args[i], XmNnoResize, (XtArgVal) TRUE); i++;
	XtSetArg(args[i], XmNresizePolicy,
		(XtArgVal) XmRESIZE_ANY); i++;
	alertContinue = XmCreateBulletinBoardDialog(parent,
		"alertContinue", args, i);
	i = 0;
	XtSetArg(args[i], XmNlabelType, (XtArgVal) XmSTRING); i++;
	XtSetArg(args[i], XmNborderWidth, (XtArgVal) 0); i++;
	XtSetArg(args[i], XmNx, (XtArgVal) 0); i++;
	XtSetArg(args[i], XmNy, (XtArgVal) 0); i++;
	alertLabelContinue = XtCreateManagedWidget("alertLabelContinue",
		xmLabelWidgetClass, alertContinue, args, i);
	i = 0;
	XtSetArg(args[i], XmNlabelString,
		XmStringCreateLtoR("Continue",
			XmSTRING_DEFAULT_CHARSET)); i++;
	XtSetArg(args[i], XmNx, (XtArgVal) 0); i++;
	XtSetArg(args[i], XmNy, (XtArgVal) 40); i++;
	alertButtonContinue =
		XtCreateManagedWidget("alertButtonContinue",
			xmPushButtonWidgetClass, alertContinue, args, i);
}	/* alert_create_continue */


/*
AlertYesNoCancel() determines which option has been selected
in a dialog window and resets the `wait' variable; it works
with alert_query().
*/
/*ARGSUSED*/
void AlertYesNoCancel(w, client_data, call_data)
Widget w;
caddr_t client_data;
XmAnyCallbackStruct call_data;
{
	if (call_data.reason == XmCR_OK)
		query_result = ALERT_YES;
	else if (call_data.reason == XmCR_CANCEL)
		query_result = ALERT_NO;
	else
		query_result = ALERT_CANCEL;
	XtUnmanageChild(alertYesNoCancel);
	query_wait = FALSE;
}	/* AlertYesNoCancel */


/*
get_alert_result() is a pop-up window function for waiting on the
user's selection to the yes-no-cancel alert query.
*/

int get_alert_result()
{
	XEvent event;

	query_wait = TRUE;				/* block until the user	*/
	while (query_wait) {			/* presses a button		*/
		XtNextEvent(&event);
		XtDispatchEvent(&event);
	}
	return query_result;
}	/* get_alert_result */


/*
alert() pops up a simple message window with a "continue" button.
*/

void alert(message)
char *message;
{
	Arg args[3];
	int i;

	i = 0;
	XtSetArg(args[i], XmNlabelString,
		XmStringCreateLtoR(message, XmSTRING_DEFAULT_CHARSET)); i++;
	XtSetValues(alertLabelContinue, args, i);
	XtManageChild(alertContinue);
}	/* alert */


/*
alert_query() pops up a dialog window;
it works with AlertYesNoCancel().
*/

void alert_query(message)
char *message;
{
	Arg args[3];
	int i;

	i = 0;
	XtSetArg(args[i], XmNmessageString,
		XmStringCreateLtoR(message, XmSTRING_DEFAULT_CHARSET)); i++;
	XtSetValues(alertYesNoCancel, args, i);
	XtManageChild(alertYesNoCancel);
}	/* alert_query */


/*
alert_beep() rings the system bell n times.
*/

void alert_beep(w, n)
int n;
{
	while (n-- > 0)
		XBell(XtDisplay(w), 100);
}	/* alert_beep */

