/****    commondel.c    ****/


/****************************************************/
/* This module contains common routines and data	*/
/* structures for the wastebasket programs.			*/
/****************************************************/


#include "commondel.h"


/*
Window-related globals used in delete.c and xwaste.c:
*/

char *temp_wastebasket_file =
	"iriswastebasket/temp.wastebasket.record";
char *wastebasket_file = "iriswastebasket/wastebasket.record";
char *wastebasket_dir = "iriswastebasket";
char home_directory[MAX_PATH_LEN];

int max_basket_entries = MAX;
int current_num_files;


/*
load_buffer() loads a buffer with text from a file.
*/

int load_buffer(file_spec, buffer)
char *file_spec, *buffer;
{
	FILE *file_ptr;

	if ((file_ptr = fopen(file_spec, "r")) == NULL)
		return FALSE;
	while ((*buffer = fgetc(file_ptr)) != EOF)
		buffer++;
	*buffer = EOS;
	fclose(file_ptr);
	return TRUE;
}	/* load_buffer */


/*
get_home_directory() examines the environment for
the value of HOME.
*/

int get_home_directory(directory)
char *directory;
{
	char *home;

	if ((home = (char *)getenv("HOME")) == NULL) {
		fprintf(stderr,
			"Unable to determine your home directory!!\n");
		return FALSE;
	}
	strcpy(directory, home);
	return TRUE;
}	/* get_home_directory */

	
/*
get_max_files() examines the environment
for the value of $WASTEBASKET_SIZE.
*/

int get_max_files()
{
	int size;
	char *str_size;

	if ((str_size = (char *)getenv("WASTEBASKET_SIZE")) == NULL)
		return MAX;
	if ((size = atoi(str_size)) < 1)
		return MAX;
	return size;
}	/* get_max_files */


/*
file_size() checks for the existence of a file using stat(),
returning -1 for a nonexistent file and the file size otherwise.
*/

int file_size(file_spec)
char *file_spec;
{
	struct stat	statbuf;

	if (stat(file_spec, &statbuf) < 0)
		return -1;
	else
		return (int)statbuf.st_size;
}	/* file_size */


/*
The following two procedures are used to encode and decode
file specifications for storage in the wastebasket.
*/

void encode_file_spec(after, before)
char *after, *before;
{
	char ch, *encode_ptr;

	while (ch = *before++)
		if (ch != '/')
			*after++ = ch;
		else {
			encode_ptr = ENCODE_STR;
			while (*after++ = *encode_ptr++)
				;
			after--;	/* don't want EOS */
		}
	*after = EOS;
}	/* encode_file_spec */


void decode_file_spec(after, before)
char *after, *before;
{
	int match;
	char *encode_ptr, *encode_str = ENCODE_STR, *next;

	while (*before) {
		if (*before == *encode_str) {
			match = TRUE;
			next = before;
			encode_ptr = encode_str;
			while (*next && *encode_ptr)
				if (*next++ != *encode_ptr++) {
					match = FALSE;
					break;
				}
			if (!match)
				*after++ = *before++;
			else {
				*after++ = '/';
				before = next;
			}
		}
		else
			*after++ = *before++;
	}
	*after = EOS;
}	/* decode_file_spec */


/*
wastebasket_empty() is a convenience function for determining
whether or not the wastebasket exists.
*/

int wastebasket_empty()
{
	char temp_file_spec[MAX_CHARS];

 	sprintf(temp_file_spec, "%s/%s", home_directory,
 		wastebasket_dir);
 	if (file_size(temp_file_spec) == -1)
 		return TRUE;
 	sprintf(temp_file_spec, "%s/%s", home_directory,
 		wastebasket_file);
 	if (file_size(temp_file_spec) == -1)
 		return TRUE;
 	return FALSE;
}	/* wastebasket_empty */

