/****    commondel.h    ****/


/********************************************************/
/* commondel.c contains common routines and data		*/
/* structures for the wastebasket deletion operations.	*/
/********************************************************/


#ifndef	COMMONDEL_H
#define	COMMONDEL_H	1

#include <memory.h>
#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>	/* stat() is used to verify file existence */



#define MAX				20		/* the DEFAULT maximum number	*/
								/* of wastebasket entries		*/

#define MAX_FILENAME_LEN        256
#define MAX_PATH_LEN            1024
#define MAX_FILE_SPEC			(MAX_PATH_LEN + MAX_FILENAME_LEN)
#define MAX_CHARS				(MAX_FILE_SPEC * 2)

#define PARSE_TOKENS	" \t\n"/* used to parse filename lists */

#define	EOS				'\0'

#define ENCODE_STR		"_SLASH_"	/* used during file spec.	*/
									/* encode/decode operations	*/

#define TRUE			1
#define FALSE			0


/*
Function declarations:
*/

extern int file_size(), load_buffer();
extern int get_home_directory();
extern int get_max_files();
extern int wastebasket_emtpy();
extern void encode_file_spec(), decode_file_spec();


/*
Window-related globals:
*/

extern char	*temp_wastebasket_file;
extern char	*wastebasket_file;
extern char	*wastebasket_dir;
extern char	home_directory[];
extern int	current_num_files, max_basket_entries;


#endif
