/****    xwaste.menu.c    ****/

/****     menu-related routines for xwaste.c    ****/


#include "xwaste.menu.h"


/*
Private globals:
*/


static Widget menuBasket, menuButton[2];


/*
menu_create() allocates the widgets for the basket menu
and sets up the callback functions.
*/

void menu_create(parent)
Widget parent;
{
	menuBasket = XmCreatePopupMenu(parent, "basketMenu", NULL, 0);
	XtAddEventHandler(parent, ButtonPressMask, False, DoMenu,
		menuBasket);
	menuButton[0] = XmCreatePushButtonGadget(menuBasket,
		"Restore to Original Directory", NULL, 0);
	XtAddCallback(menuButton[0],XmNactivateCallback,
		MenuRestore, NULL);
	menuButton[1] = XmCreatePushButtonGadget(menuBasket,
		"Permanently Delete/Remove", NULL, 0);
	XtAddCallback(menuButton[1], XmNactivateCallback,
		MenuDelete, NULL);
	XtManageChildren(menuButton, 2);
}	/* menu_create */


/*
DoMenu() activates the menu.
*/
/*ARGSUSED*/
void DoMenu(w, menu, event)
Widget w, menu;
XButtonEvent *event;
{
	if (event->button != Button3)
		return;
	XmMenuPosition(menu, event);
	XtManageChild(menu);
}	/* DoMenu */


/*
MenuDelete() permanently deletes a file.
*/
/*ARGSUSED*/
void MenuDelete(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	basket_delete_file();
}	/* MenuDelete */


/*
MenuRestore() restores a file to its original directory.
*/
/*ARGSUSED*/
void MenuRestore(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	basket_restore_file();
}	/* MenuRestore */


