/****  simpleact.c  ****/


#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#ifdef X11R3
#include <X11/Box.h>
#include <X11/Command.h>
#include <X11/Form.h>
#include <X11/Label.h>
#else
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#endif

#include <stdio.h>



/*
Functions:
*/

void main(), create_main_widgets(), create_widgets_with_actions();
void ActivatePopup(), ButtonAction(), Quit();


/*
Private Widgets:
*/

static Widget topLevel, buttonBoxMain, buttonPopup, buttonQuit;
static Widget actionShell, actionLabel, actionBox,
	actionButton1, actionButton2;


/*
main() delegates everything.
*/

void main(argc, argv)
int argc;
char *argv[];
{
	topLevel = XtInitialize(argv[0], "TestPopup", NULL, 0,
		&argc, argv);
	create_main_widgets();
	create_widgets_with_actions();
	XtRealizeWidget(topLevel);
	XtMainLoop();
}	/* main */


/*
create_main_widgets() sets up the buttonbox, buttons,
and their callbacks.
*/

void create_main_widgets()
{
	Arg args[5];
	int i;

	buttonBoxMain = XtCreateManagedWidget("buttonBoxMain",
		boxWidgetClass, topLevel, NULL, 0);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Quit"); i++;
	buttonQuit = XtCreateManagedWidget("buttonQuit",
		commandWidgetClass, buttonBoxMain, args, i);
	XtAddCallback(buttonQuit, XtNcallback, Quit, NULL);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Test Popup"); i++;
	buttonPopup = XtCreateManagedWidget("buttonPopup",
		commandWidgetClass, buttonBoxMain, args, i);
	XtAddCallback(buttonPopup, XtNcallback, ActivatePopup, NULL);
}	/* create_main_widgets */


/*
create_widgets_with_actions() sets up the pop-up shell,
its buttons, and implements their actions.
*/

void create_widgets_with_actions()
{

	static char button_translations[] =
		"#override\n\
		<Btn1Down>,<Btn1Up>:	buttonaction()";
	static XtActionsRec button_actions[] = {
		{"buttonaction", ButtonAction},
	};
	XtTranslations button_trans_table;
	Arg args[5];
	int i;

	XtAddActions(button_actions, XtNumber(button_actions));
	button_trans_table =
		XtParseTranslationTable(button_translations);
	actionShell= XtCreatePopupShell("actionShell",
		transientShellWidgetClass, topLevel, NULL, 0);
	actionBox = XtCreateManagedWidget("actionBox",
		formWidgetClass, actionShell, NULL, 0);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Press a button."); i++;
	XtSetArg(args[i], XtNborderWidth, (XtArgVal) 0); i++;
	actionLabel = XtCreateManagedWidget("actionLabel",
		labelWidgetClass, actionBox, args, i);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Button 1"); i++;
	XtSetArg(args[i], XtNfromVert, (XtArgVal) actionLabel); i++;
	actionButton1 = XtCreateManagedWidget("actionButton1",
		commandWidgetClass, actionBox, args, i);
	XtOverrideTranslations(actionButton1, button_trans_table);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Button 2"); i++;
	XtSetArg(args[i], XtNfromVert, (XtArgVal) actionLabel); i++;
	XtSetArg(args[i], XtNfromHoriz, (XtArgVal) actionButton1); i++;
	actionButton2 = XtCreateManagedWidget("actionButton2",
		commandWidgetClass, actionBox, args, i);
	XtOverrideTranslations(actionButton2, button_trans_table);
}	/* create_widgets_with_actions */


/*
Callbacks:
*/

/*ARGSUSED*/
void Quit(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	printf("You pressed the Quit button.\n");
	exit(0);
}	/* Quit */


/*ARGSUSED*/
void ActivatePopup(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	XtPopup(actionShell, XtGrabNone);
}	/* ActivatePopup */


/*
Action functions:
*/

void ButtonAction(w, event)
Widget w;
XEvent *event;
{
	XtPopdown(actionShell);
	if (w == actionButton1) {
		printf("You pressed button 1.\n");
		printf("Button 1 resides in the window with id: %ld\n",
			(long) event->xbutton.window);
	}
	else {
		printf("Button 2 resides in the window with id: %ld\n",
			(long) event->xbutton.window);
		printf("You pressed button 2.\n");
	}
}	/* ButtonAction */
