/****  simplepopup.c  ****/


#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#ifdef X11R3
#include <X11/Box.h>
#include <X11/Command.h>
#include <X11/Form.h>
#include <X11/Label.h>
#else
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#endif

#include <stdio.h>



/*
Functions:
*/

void main(), create_main_widgets(), create_popup_widgets();
void ActivatePopup(), DeactivatePopup(), Quit();


/*
Private Widgets:
*/

static Widget topLevel, buttonBoxMain, buttonPopup, buttonQuit;
static Widget popupShell, popupLabel, popupBox,
	popupButton1, popupButton2;


/*
main() delegates everything.
*/

void main(argc, argv)
int argc;
char *argv[];
{
	topLevel = XtInitialize(argv[0], "TestPopup", NULL, 0,
		&argc, argv);
	create_main_widgets();
	create_popup_widgets();
	XtRealizeWidget(topLevel);
	XtMainLoop();
}	/* main */


/*
create_main_widgets() sets up the buttonbox, buttons,
and their callbacks.
*/

void create_main_widgets()
{
	Arg args[5];
	int i;

	buttonBoxMain = XtCreateManagedWidget("buttonBoxMain",
		boxWidgetClass, topLevel, NULL, 0);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Quit"); i++;
	buttonQuit = XtCreateManagedWidget("buttonQuit",
		commandWidgetClass, buttonBoxMain, args, i);
	XtAddCallback(buttonQuit, XtNcallback, Quit, NULL);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Test Popup"); i++;
	buttonPopup = XtCreateManagedWidget("buttonPopup",
		commandWidgetClass, buttonBoxMain, args, i);
	XtAddCallback(buttonPopup, XtNcallback, ActivatePopup, NULL);
}	/* create_main_widgets */


/*
create_popup_widgets() sets up the pop-up shell, its buttons,
and their callbacks.
*/

void create_popup_widgets()
{
	Arg args[5];
	int i;

	popupShell= XtCreatePopupShell("popupShell",
		transientShellWidgetClass, topLevel, NULL, 0);
	popupBox = XtCreateManagedWidget("popupBox",
		formWidgetClass, popupShell, NULL, 0);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Press a button."); i++;
	XtSetArg(args[i], XtNborderWidth, (XtArgVal) 0); i++;
	popupLabel = XtCreateManagedWidget("popupLabel",
		labelWidgetClass, popupBox, args, i);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Button 1"); i++;
	XtSetArg(args[i], XtNfromVert, (XtArgVal) popupLabel); i++;
	popupButton1 = XtCreateManagedWidget("popupButton1",
		commandWidgetClass, popupBox, args, i);
	XtAddCallback(popupButton1, XtNcallback, DeactivatePopup,
		"application data for button 1");
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Button 2"); i++;
	XtSetArg(args[i], XtNfromVert, (XtArgVal) popupLabel); i++;
	XtSetArg(args[i], XtNfromHoriz, (XtArgVal) popupButton1); i++;
	popupButton2 = XtCreateManagedWidget("popupButton2",
		commandWidgetClass, popupBox, args, i);
	XtAddCallback(popupButton2, XtNcallback, DeactivatePopup,
		"application data for button 2");
}	/* create_popup_widgets */


/*
Callbacks:
*/

/*ARGSUSED*/
void Quit(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	printf("You pressed the Quit button.\n");
	exit(0);
}	/* Quit */


/*ARGSUSED*/
void ActivatePopup(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	XtPopup(popupShell, XtGrabNone);
}	/* ActivatePopup */


/*ARGSUSED*/
void DeactivatePopup(w, client_data, call_data)
Widget w;
caddr_t client_data;	/* the application data */
caddr_t call_data;
{
	XtPopdown(popupShell);
	if (w == popupButton1)
		printf(
			"You pressed button 1; its associated data is:\n%s\n",
			client_data);
	else
		printf(
			"You pressed button 2; its associated data is:\n%s\n",
			client_data);
}	/* DeactivatePopup */

