/**  testrespbox.c  **  tests the variable-button response box  **/


#include "respbox.h"



#define EXIT_BTN	1			/* button values */
#define CANCEL_BTN	2


/*
Functions:
*/

void main(), create_main_buttons();
void Quit(), Question();


/*
Private Widgets:
*/

static Widget topLevel, buttonBox, buttonQuestion, buttonQuit;


/*
main() manages a simple demonstration of a two-button,
blocking response box.
*/

void main(argc, argv)
int argc;
char *argv[];
{
	topLevel = XtInitialize(argv[0], "TestResponse", NULL, 0,
		&argc, argv);

	create_main_buttons(topLevel);
	response_create(topLevel, 2);			/* no error checks */
	response_add_button("exitButton", "Exit");
	response_add_button("cancelButton", "Cancel");
	
	XtRealizeWidget(topLevel);
	XtMainLoop();
}	/* main */


/*
create_main_buttons() sets up the buttonbox, its buttons,
and their callbacks.
*/

void create_main_buttons(parent)
Widget parent;
{
	Arg args[3];
	int i;

	buttonBox = XtCreateManagedWidget("buttonBox",
		boxWidgetClass, parent, NULL, 0);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Quit"); i++;
	buttonQuit = XtCreateManagedWidget("buttonQuit",
		commandWidgetClass, buttonBox, args, i);
	XtAddCallback(buttonQuit, XtNcallback, Quit, NULL);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Test Buttons..."); i++;
	buttonQuestion = XtCreateManagedWidget("buttonQuestion",
		commandWidgetClass, buttonBox, args, i);
	XtAddCallback(buttonQuestion, XtNcallback, Question, NULL);
}	/* create_main_buttons */


/*
Quit() terminates the application.
*/
/*ARGSUSED*/
void Quit(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	response_cleanup();
	exit(0);
}	/* Quit */


/*
Ouestion() raises the question.
*/
/*ARGSUSED*/
void Question(w, client_data, call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
	response_query("Would you like to exit?");
	if (response_get_result() == EXIT_BTN) {
		response_query("Confirm exit!");
		if (response_get_result() == EXIT_BTN) {
			printf("Application terminated.\n");
			response_cleanup();
			exit(0);
		}
		else
			printf("Application NOT terminated.\n");
	}
	else
		printf("Application NOT terminated.\n");
}	/* Question */

