/****    Alert.h    ****/

/****    public declarations/definitions for Alert.c    ****/

#ifndef	_XiAlert_h
#define	_XiAlert_h	1

/********************************************************************
*  Copyright (c) 1990 Iris Computing Laboratories.
*
*  This software is provided for demonstration purposes only.  As
*  freely-distributed, modifiable source code, this software carries
*  absolutely no warranty.
********************************************************************/

/********************************************************************
An Alert widget implements a pop-up, blocking, message window that
supports buttons.  It can be used to query the user with yes-no-
cancel type messages, or for simple warning and informatory mes-
sages that require a one-button, "continue" type response.  The
client can create multiple alert boxes.
   An Alert widget is shell-less; the client must provide the
enclosing shell.  A convenience function, XiAlertPopup(), is
provided for popping up the alert box.  It returns the button
values associated with the selected button.  The second argument
provides the alert box message and the third argument is either
XiBEEP or XiNOBEEP.  The duration of the beep is controlled by a
resource, XiNbeepDuration.  A separate convenience function,
XiAlertBeep(), is available for sounding the terminal bell with the
duration specified by XiNbeepDuration.
   A client can add buttons to an alert box with XiAlertAddButton().
A button label, a button value (integer), a callback function,
and callback data can be associated with each button.
   A convenience function, XiAlertResetProperKeyboardFocus(), can
be used to associate a client-supplied function for resetting the
keyboard focus after each invocation of the pop-up alert box.  By
default, no keyboard focus-setting function is executed after a
pop-down operation.  The keyboard focus issue sometimes arises with
certain combinations of widgets and window managers.

Resources:

Name			Class			Data Type		Default		Modify?
----			-----			---------		-------		-------
XiNmessage		XiCMessage		String			""			OK
XiNbeepDuration	XiCBeepDuration	int				1			OK
XiNfont			XiCFont			XFontStruct *	XtDefaultFont

   Public interfaces are described below.
********************************************************************/

#ifdef X11R3
#include <X11/Form.h>
#else
#include <X11/Xaw/Form.h>
#endif


/*
Used with XiAlertPopup():
*/

#define XiNOBEEP	0
#define XiBEEP		1


/*
Resource definitions:
*/

#define XiNmessage 		"message"			/* OK to modify */
#define XiNbeepDuration	"beepDuration"		/* OK to modify */
#define XiNfont			"font"
#define XiCMessage 		"Message"
#define XiCBeepDuration	"BeepDuration"
#define XiCFont			"Font"


typedef struct _XiAlertClassRec *XiAlertWidgetClass;
typedef struct _XiAlertRec *XiAlertWidget;

extern WidgetClass xiAlertWidgetClass;


/*
Public functions:
*/

extern void XiAlertAddButton();
/*	XiAlertWidget alert_widget;
	char *button_name;
	int button_value;
	void (*callback_proc)();
	caddr_t callback_arg;
*/

extern int XiAlertPopup();
/*	XiAlertWidget alert_widget;
	char *message;
	Boolean ring_bell;
*/

extern int XiAlertMap();
/*	XiAlertWidget alert_widget;
*/

extern void XiAlertBeep();
/*	XiAlertwidget alert_widget;
	int num_beeps;
*/

extern void XiAlertResetProperKeyboardFocus();
/*	void (*reset_keyboard_focus_proc)();
*/

#endif /* _XiAlert_h  */
