/****    AlertP.h    ****/

/****    private declarations/definitions for Alert.c    ****/


#ifndef	_XiAlertP_h
#define	_XiAlertP_h


#include "Alert.h"
#ifdef X11R3
#include <X11/FormP.h>
#else
#include <X11/Xaw/FormP.h>
#endif


#define ALERT_MAX_BUTTONS			5

#define ALERT_STD_BEEP_DURATION		1
#define ALERT_MAX_BEEP_DURATION		25
#define ALERT_DEFAULT_WIDTH			400
#define ALERT_DEFAULT_HEIGHT		175

#define ALERT_DEFAULT_MSG		"A message goes here!"


typedef struct _XiAlertClassPart {		/* class definition */
	int dummy;
} XiAlertClassPart;

typedef struct _XiAlertClassRec {
	CoreClassPart core_class;
	CompositeClassPart composite_class;
	ConstraintClassPart constraint_class;
	FormClassPart form_class;
	XiAlertClassPart alert_class;
} XiAlertClassRec;

extern XiAlertClassRec xiAlertClassRec;

typedef struct _XiAlertButtonPart {
	Widget wid;
	int value;
} XiAlertButtonPart;

typedef struct _XiAlertPart {			/* instance definition */
	char *msg;
	int std_beep_duration;
	XFontStruct *font;
	Widget msgW;
	XiAlertButtonPart buttonW[ALERT_MAX_BUTTONS];
	int num_buttons;
	int query_result;
	int query_wait;
} XiAlertPart;


typedef struct _XiAlertRec {
	CorePart core;
	CompositePart composite;
	ConstraintPart constraint;
	FormPart form;
	XiAlertPart alert;
} XiAlertRec;


typedef struct {
	int dummy;
} XiAlertConstraintsPart;


typedef struct _XiAlertConstraintsRec {
	FormConstraintsPart form;
	XiAlertConstraintsPart alert;
} XiAlertConstraintsRec, *XiAlertConstraints;

#endif	/* _XiAlertP_h */
