/****    testalert.c    ****    tests the alert box widget ****/


#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#ifdef X11R3
#include <X11/Box.h>
#include <X11/Command.h>
#else
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#endif
#include <Ximisc.h>
#include "Alert.h"


/*
Functions:
*/

void TestAlertBox1(), TestAlertBox2(), Quit(), AlertCB();


/*
Private globals:
*/

static Widget testAlert1, testAlert2;
static XFontStruct *font;


void main(argc, argv)
int argc;
char **argv;
{
	Widget topLevel, testBox, alertShell1, alertShell2,
		testButton1, testButton2, quitButton;
	Arg args[7];
	int i;

	topLevel = XtInitialize(argv[0], "TestAlert",
		NULL, 0, &argc, argv);
	font = load_font(topLevel, "testalert", "8x13");
	i = 0;
	XtSetArg(args[i], XtNallowShellResize, (XtArgVal) TRUE); i++;
	alertShell1 = XtCreatePopupShell("alertShell1",
		transientShellWidgetClass, topLevel, args, i);
	i = 0;
	XtSetArg(args[i], XtNfont,		/* test this one with	*/
		(XtArgVal) font); i++;		/* an alternate font	*/
	testAlert1 = XtCreateManagedWidget("testAlert1",
		xiAlertWidgetClass, alertShell1, args, i);
	i = 0;
	XtSetArg(args[i], XtNallowShellResize, (XtArgVal) TRUE); i++;
	alertShell2 = XtCreatePopupShell("alertShell2",
		transientShellWidgetClass, topLevel, args, i);
	testAlert2 = XtCreateManagedWidget("testAlert2",
		xiAlertWidgetClass, alertShell2, NULL, 0);

	testBox = XtCreateManagedWidget("box", boxWidgetClass,
		topLevel, NULL, 0);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Button Set 1..."); i++;
	testButton1 = XtCreateManagedWidget("testButton1",
		commandWidgetClass, testBox, args, i);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Button Set 2..."); i++;
	testButton2 = XtCreateManagedWidget("testButton2",
		commandWidgetClass, testBox, args, i);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Quit"); i++;
	quitButton = XtCreateManagedWidget("quitButton",
		commandWidgetClass, testBox, args, i);
	XtAddCallback(testButton1, XtNcallback, TestAlertBox1, NULL);
	XtAddCallback(testButton2, XtNcallback, TestAlertBox2, NULL);
	XtAddCallback(quitButton, XtNcallback, Quit, NULL);
	XiAlertAddButton(testAlert1, "Button 1", 3, AlertCB, "three");
	XiAlertAddButton(testAlert1, "Button 2", 6, AlertCB, "six");
	XiAlertAddButton(testAlert1, "Button 3", 9, AlertCB, "nine");
	XiAlertAddButton(testAlert2, "Button 1", 2, AlertCB, "two");
	XiAlertAddButton(testAlert2, "Button 2", 4, AlertCB, "four");
	XtRealizeWidget(topLevel);
	XtMainLoop();
}	/* main */


/*ARGSUSED*/
void TestAlertBox1(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	int result;

	result = XiAlertPopup(testAlert1,
		"This is a test!  Press any button...", XiBEEP);
	/*
	Normally, you would do something useful with the value attached
	to the pressed button; for now, just print the value.
	*/
	printf("You chose the button with value: %d\n", result);
}	/* TestAlertBox1 */


/*ARGSUSED*/
void TestAlertBox2(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	Arg args[3];
	int i, result;

	i = 0;
	XtSetArg(args[i], XiNmessage,
		(XtArgVal) "Testing alert box #2!  Press any button..."); i++;
	XtSetArg(args[i], XiNbeepDuration, (XtArgVal) 4); i++;
	XtSetValues(testAlert2, args, i);
	result = XiAlertMap(testAlert2);
	/*
	Normally, you would do something useful with the value attached
	to the pressed button; for now, just print the value.
	*/
	printf("You chose the button with value: %d\n", result);
}	/* TestAlertBox2 */


/*ARGSUSED*/
void AlertCB(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	printf("A button was pressed...\n");
	printf("Its callback data was: %s\n", client_data);
}	/* AlertCB */


/*ARGSUSED*/
void Quit(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	XFreeFont(XtDisplay(w), font);
	printf("Program terminated...\n");
	exit(0);
}	/* Quit */

