/****    Button.h    ****/

/****    public declarations/definitions for Button.c    ****/

#ifndef	_XiButton_h
#define	_XiButton_h	1

/********************************************************************
*  Copyright (c) 1990 Iris Computing Laboratories.
*
*  This software is provided for demonstration purposes only.  As
*  freely-distributed, modifiable source code, this software carries
*  absolutely no warranty.
********************************************************************/

/********************************************************************
A Button widget is a simple, non-command, button.  Although a button
widget could be created for stand-alone use, it is designed to serve
as a foundation widget for building higher level widgets, such as
choice boxes and menus.
   A Button widget supports a selection callback list.  A button also
allows an integer value to be associated with it.  This feature is
provided so that the client program can associate an application-
specific value with each button in, say, a choice box, and then
determine which button is currently selected by manipulating button
values.  Note, however, that the client is responsible for imposing
this logic on a SET of buttons; a button widget can only get and set
button values.  The public function XiButtonGetValue() returns the
integer value associated with a button.  A value can be provided or
modified dynamically with a resource value or by calling the function
XiButtonSetValue().
   A Button widget can be selected and deselected.  By default, this
action operates as a toggle via a <ClickLeft>; however, a higher
level widget can override the default behavior.  Two public
functions, XiButtonSelect() and XiButtonDeselect(), can be used for
programmatic selection and deselection, respectively.  A selected
button is "highlighted" with a one-pixel wide rectangle inside the
button's border.  When a button is selected, its callback list, if
any, is traversed--after all other selection operations are complete.
A third function, XiButtonSelectNoCB(), can be use to programmati-
cally select a button without executing any associated callbacks. 
   A Button widget's label can be modified dynamically; however, the
pixmap and window are not resized in this case.  If the new label is
longer, there may be clipping in the Button window.  Note that by
default the width of a button is based on the number of characters in
(length of) the label.  Thus, by default a collection of buttons will
having varying width.  The client can override this behavior with the
XiNlength resource, which specifies the number of characters to use
in determining a button's length/width.  For example, when adding
several buttons to a higher-level widget, or application, you can
determine the maximum number of characters in the longest label, and
then use this value for the XiNlength resource for each button in
order to produce buttons of uniform length/width.  This resource is
used only during the creation of buttons; you can not "expand" a
button dynamically.

Resources (see Button.h also):

Name			Class			Data Type		Default		Modify?
----			-----			---------		-------		-------
XiNlabel		XiCLabel		String			""			OK
XiNlength		XiCLength		int				strlen(
												label)
XiNvalue		XiCValue		int				-1			OK
XiNselect-		XiCSelect-		XtCallbackList	NULL		OK
Callback		Callback
XiNfont			XiCFont			XFontStruct *	XtDefaultFont
XiNforeground	XiCForeground	Pixel			XtDefaultForeground

   Public interfaces are described below.
********************************************************************/

#ifdef X11R3
#include <X11/Simple.h>
#else
#include <X11/Xaw/Simple.h>
#endif


#define XiBUTTON_NOVALUE		-1


/*
Resource definitions:
*/
	
#define XiNlabel					"label"			/* OK to modify */
#define XiNlength 					"length"
#define XiNvalue 					"value"			/* OK to modify */
#define XiNselectCallback			"selectCallback"/* OK to modify */
#define XiNwidth					"width"
#define XiNheight					"height"
#define XiNborderWidth				"borderWidth"
#define XiNfont 					"font"
#define XiNforeground				"foreground"
#define XiCLabel					"Label"
#define XiCLength 					"Length"
#define XiCValue 					"Value"
#define XiCSelectCallback			"SelectCallback"
#define XiCCallback					"Callback"
#define XiCWidth					"Width"
#define XiCHeight					"Height"
#define XiCBorderWidth				"BorderWidth"
#define XiCFont						"Font"
#define XiCForeground				"Foreground"


typedef struct _XiButtonClassRec *XiButtonWidgetClass;
typedef struct _XiButtonRec *XiButtonWidget;

extern WidgetClass xiButtonWidgetClass;


/*
Public functions:
*/

extern int XiButtonGetValue();
/*	XiButtonWidget button_widget;
*/

extern void XiButtonSetValue();
/*	XiButtonWidget button_widget;
	int value;
*/

extern int XiButtonIsSelected();
/*	XiButtonWidget button_widget;
*/

extern void XiButtonSelect();
/*	XiButtonWidget button_widget;
*/

extern void XiButtonSelectNoCB();
/*	XiButtonWidget button_widget;
*/

extern void XiButtonDeselect();
/*	XiButtonWidget button_widget;
*/

#endif /* _XiButton_h  */

