/****    ButtonP.h    ****/

/****    private declarations/definitions for Button.c    ****/


#ifndef	_XiButtonP_h
#define	_XiButtonP_h


#include "Button.h"
#ifdef X11R3
#include <X11/SimpleP.h>
#else
#include <X11/Xaw/SimpleP.h>
#endif


#define BTN_NOTHING						""
#define BTN_DEFAULT_VALUE				XiBUTTON_NOVALUE
#define BTN_DEFAULT_LENGTH				-1

#define BTN_DEFAULT_WIDTH				75
#define BTN_DEFAULT_HEIGHT				30

#define BTN_INTERNAL_HORIZ_PAD			5
#define BTN_INTERNAL_VERT_PAD			5

#define BTN_WITH_CB						-1
#define BTN_WITHOUT_CB					-2


#define EOS								'\0'


typedef struct _XiButtonClassPart {		/* class definition */
	int dummy;
} XiButtonClassPart;

typedef struct _XiButtonClassRec {
	CoreClassPart core_class;
	SimpleClassPart simple_class;
	XiButtonClassPart button_class;
} XiButtonClassRec;

extern XiButtonClassRec xiButtonClassRec;


typedef struct _XiButtonPart {			/* instance definition */
	Pixel foreground;
	char *label;				/* resource-supplied label */
	char *private_label;		/* private copy of label */
	XFontStruct *font;
	Pixmap pixmap;
	GC gc;						/* for text and rectangle */
	GC cgc;						/* clears the rectangle */
	Dimension width, height;	/* does not include padding */
	Boolean selected;			/* is button currently selected? */
	int value;					/* optional */
	int length;					/* length in chars. of button text */
	XtCallbackList cb_list;		/* see select_button() */
} XiButtonPart;


typedef struct _XiButtonRec {
	CorePart core;
	SimplePart simple;
	XiButtonPart button;
} XiButtonRec;


#endif	/* _XiButtonP_h */
