/****    Choice.h    ****/

/****    public declarations/definitions for Choice.c    ****/

#ifndef	_XiChoice_h
#define	_XiChoice_h	1

/********************************************************************
*  Copyright (c) 1990 Iris Computing Laboratories.
*
*  This software is provided for demonstration purposes only.  As
*  freely-distributed, modifiable source code, this software carries
*  absolutely no warranty.
********************************************************************/

/********************************************************************
A Choice widget is a simple, multiple-choice selection box for speci-
fying, or choosing from, several application options.  For example,
a calculator might employ a choice box for allowing the user to
select one of several numeric bases.  A Choice widget collects
Button widgets within a box, allowing the client to select one, or
more, buttons (items), depending on the value of the resource
XiNexclusive.
   The label, if any, appears, by default, in the top of the choice
box; this can be altered with the resource XiNlabelOnLeft.  Items,
by default, are arranged from left to right below the label/title;
this can be altered with the resource XiNvertical.
   The choice box inherits its cursor from its parent; however, you
can specify a different cursor for the ITEMS/BUTTONS using the
resource XiNitemCursor.
   Items are added subsequent to choice box creation using either
XiChoiceAddItem() for adding items one at a time or
XiChoiceAddItems() for adding items via an array specification.  The
latter approach is strongly recommended, since this widget supports
two different forms, namely, standard choice boxes and simple menus.
XiChoiceAddItem() is a low-level function that requires FOUR argu-
ments, even if, in the case of menus, only three arguments are
appropriate.  XiChoiceAddItems() accommodates two different data
types for its second argument, either XiChoiceItem or
XiChoiceMenuItem.  Examples of how to set up both forms are given
below.
   For exclusive-mode choice boxes that are NOT in menu form, a
default item can be specified using the resource XiNdefaultItem.
Note that it is possible for the user to de-select the default item,
leaving no items selected.  It is the responsibility of the client
to monitor this condition, if it isn't acceptable, and reset the
default using one of the public functions listed below.
   For choice boxes, the border width of the buttons defaults to that
for the choice box itself.  You can override the default with the
resource XiNitemBorderWidth.  Note that for horizontal choice boxes
where each item label is a single word, try setting the border width
for BOTH the box and the items to 0, using the common resource
XtNborderWidth in the standard way.  Also, locate the choice box la-
bel on the left with XiNlabelOnLeft.  For many applications, these
settings provide a one-line, "clean and uncluttered" appearance.  If
any item label is more than one word, try setting the choice box
border to 0 and the item border to 1.
   
Resources (see Button.h also):

Name			Class			Data Type		Default		Modify?
----			-----			---------		-------		-------
XiNlabel		XiCLabel		String			""			OK
XiNexclusive	XiCExclusive	Boolean			FALSE
XiNvertical		XiCVertical		Boolean			FALSE
XiNmenuForm		XiCMenuForm		Boolean			FALSE
XiNdefaultItem  XiCDefaultItem	int				1
XiNlabelOnLeft	XiCLabelOnLeft	Boolean			FALSE
XiNitemCursor	XiCItemCursor	Cursor			None
XiNitemBorder-	XiCItemBorder-	int				same as
Width			Width							choice box
XiNfont			XiCFont			XFontStruct *	XtDefaultFont

   Public interfaces are described below.
********************************************************************/

#include "Button.h"


/*
Resource definitions (see Button.h also):
*/

#define XiNlabel					"label"
#define XiNexclusive				"exclusive"
#define XiNdefaultItem				"defaultItem"
#define XiNlabelOnLeft				"labelOnLeft"
#define XiNvertical					"vertical"
#define XiNmenuForm					"menuForm"
#define XiNitemBorderWidth			"itemBorderWidth"
#define XiNitemCursor				"itemCursor"
#define XiCLabel					"Label"
#define XiCExclusive				"Exclusive"
#define XiCDefaultItem				"DefaultItem"
#define XiCLabelOnLeft				"LabelOnLeft"
#define XiCVertical					"Vertical"
#define XiCMenuForm					"MenuForm"
#define XiCItemBorderWidth			"ItemBorderWidth"
#define XiCItemCursor				"ItemCursor"


typedef struct _XiChoiceClassRec *XiChoiceWidgetClass;
typedef struct _XiChoiceRec *XiChoiceWidget;

extern WidgetClass xiChoiceWidgetClass;


/****
XiChoiceItem is used with XiChoiceAddItems() (note the plural) to
define a null-terminated list of items of type XiChoiceItem, allowing
choice items to be defined with an array specification and added to
the box with one function call, instead of individually with
XiChoiceAddItem().  Example:

static XiChoiceItem item_list[] = {
	{"Bin", 2, ChoiceCB, "Binary Data"},
	{"Dec", 10, ChoiceCB, "Decimal Data"},
	{NULL, NULL, NULL, NULL},
};
	...
	example = XtCreateManagedWidget("example",
		xiChoiceWidgetClass, exampleParent, args, i);
	XiChoiceAddItems(example, item_list);
	...

****/


typedef struct {
	char *label;
	int value;
	void (*callback_proc)();		/* or, ...			*/
/*	XtCallbackProc callback_proc; **** client's view?	*/
	caddr_t client_data;
} XiChoiceItem;


/****
XiChoiceMenuItem is used with XiChoiceAddItems() to define a
null-terminated list of items of type XiChoiceMenuItem, allowing
menu items to be defined with an array specification and added
to the menu with one function call, instead of individually with
XiChoiceAdditem().  Example:

static XiChoiceMenuItem item_list[] = {
	{"Menu Label 1", MenuCB, "Menu Data 1"},
	{"Menu Label 2", MenuCB, "Menu Data 2"},
	{NULL, NULL, NULL},
};
	...
	example = XtCreateManagedWidget("example",
		xiChoiceWidgetClass, exampleParent, args, i);
	XiChoiceAddItems(example, item_list);
	...

****/

typedef struct {
	char *label;
	void (*callback_proc)();		/* or, ...			*/
/*	XtCallbackProc callback_proc; **** client's view?	*/
	caddr_t client_data;
} XiChoiceMenuItem;


/*
Public functions:
*/

extern void XiChoiceMenuPopup();
/*	XiChoiceWidget choice_widget;
*/

extern int XiChoiceIsExclusive();
/*	XiChoiceWidget choice_widget;
*/

extern void XiChoiceAddItems();				/* plural */
/*	XiChoiceWidget choice_widget;
	caddr_t item_addr;
*/

extern void XiChoiceAddItem();				/* singular */
/*	XiChoiceWidget choice_widget;
	char *item_label;
	int item_value;
	void (*callback_proc)();	or, XtCallbackProc callback_proc;
	caddr_t client_data;
*/

extern int *XiChoiceGetItems();
/*	XiChoiceWidget choice_widget;
*/

extern int XiChoiceGetSelectedItem();		/* exclusive mode only */
/*	XiChoiceWidget choice_widget;
*/

extern int XiChoiceGetDefaultItem();		/* exclusive mode only */
/*	XiChoiceWidget choice_widget;
*/

extern int XiChoiceSelectedItemIsDefault();	/* exclusive mode only */
/*	XiChoiceWidget choice_widget;
*/

extern int XiChoiceGetNumItems();
/*	XiChoiceWidget choice_widget;
*/

extern int XiChoiceGetValue();				/* NOT zero-based */
/*	XiChoiceWidget choice_widget;
	int item_number;
*/

extern void XiChoiceSelectItem();			/* NOT zero-based */
/*	XiChoiceWidget choice_widget;
	int item_number;
*/

extern void XiChoiceDeselectItem();			/* NOT zero-based */
/*	XiChoiceWidget choice_widget;
	int item_number;
*/

extern int XiChoiceItemIsSelected();		/* NOT zero-based */
/*	XiChoiceWidget choice_widget;
	int item_number;
*/

#endif /* _XiChoice_h  */
