/****    ChoiceP.h    ****/

/****    private declarations/definitions for Choice.c    ****/

#ifndef	_XiChoiceP_h
#define	_XiChoiceP_h

#include "Choice.h"
#ifdef X11R3
#include <X11/FormP.h>
#else
#include <X11/Xaw/FormP.h>
#endif
#include "ButtonP.h"


#define CHOICE_DEFAULT_LABEL			""

#define CHOICE_DEFAULT_ITEM				1

#define CHOICE_DEFAULT_WIDTH			100
#define CHOICE_DEFAULT_HEIGHT			65
#define CHOICE_DEFAULT_BTN_BORDER_WIDTH	-1

#define CHOICE_MAX_ITEMS				10

#define CHOICE_IGNORE_ITEM_LEN			-1

#define EOS						'\0'



typedef struct _XiChoiceClassPart {		/* class definition */
	int dummy;
} XiChoiceClassPart;

typedef struct _XiChoiceClassRec {
	CoreClassPart core_class;
	CompositeClassPart composite_class;
	ConstraintClassPart constraint_class;
	FormClassPart form_class;
	XiChoiceClassPart choice_class;
} XiChoiceClassRec;

extern XiChoiceClassRec xiChoiceClassRec;


typedef struct _XiChoiceItemPart {
	XiButtonWidget wid;
	int value;
} XiChoiceItemPart;


typedef struct _XiChoicePart {			/* instance definition */
	char *label;
	XFontStruct *font;			/* used during dimension calc.s */
	Cursor item_cursor;			/* used for buttons */
	Dimension width, height;	/* dimensions of the frame */
	int btn_border_width;		/* negative used to set default */
	Widget labelW;
	XiChoiceItemPart itemW[CHOICE_MAX_ITEMS];
	int num_items;
	int default_item;
	int items_selected[CHOICE_MAX_ITEMS];/* public list; see	*/
										/* XiChoiceGetItems()	*/
	Boolean exclusive;			/* allow exclusive choices only? */
	Boolean label_on_left;		/* label place on left or on top */
	Boolean vertical;			/* vertical or horiz. orientation? */
	int max_item_len;			/* used for uniform length items */
	Boolean menu_form;			/* impose menu policy? */
} XiChoicePart;


typedef struct _XiChoiceRec {
	CorePart core;
	CompositePart composite;
	ConstraintPart constraint;
	FormPart form;
	XiChoicePart choice;
} XiChoiceRec;


typedef struct {
	int dummy;
} XiChoiceConstraintsPart;


typedef struct _XiChoiceConstraintsRec {
	FormConstraintsPart form;
	XiChoiceConstraintsPart choice;
} XiChoiceConstraintsRec, *XiChoiceConstraints;

#endif	/* _XiChoiceP_h */
