/****  testbutton.c  ****  tests the button widget  ****/


#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#ifdef X11R3
#include <X11/Command.h>
#include <X11/Form.h>
#else
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#endif

#include <Ximisc.h>
#include "Button.h"


/*
Functions:
*/

void ChangeLabel(), PrintSelection(), Quit();


/*
Private globals:
*/

static Widget testButton;
static XFontStruct *font;


/*
main() sets up a button inside a box with command buttons for
quitting the application and dynamically changing the button's
label.  Several resource values are tested.
*/

void main(argc, argv)
int argc;
char **argv;
{
	Widget topLevel, testBox, changeButton, quit;
	Arg args[10];
	int i;

	topLevel = XtInitialize(argv[0], "TestButton",
		NULL, 0, &argc, argv);
	font = load_font(topLevel, "testbutton", "8x13");
	i = 0;
	testBox = XtCreateManagedWidget("testBox", formWidgetClass,
		topLevel, args, i);
	i = 0;
	XtSetArg(args[i], XiNlabel, (XtArgVal) "Test Button"); i++;
	XtSetArg(args[i], XiNborderWidth, (XtArgVal) 2); i++;
	XtSetArg(args[i], XiNfont, (XtArgVal) font); i++;
/*	XtSetArg(args[i], XiNvalue, (XtArgVal) 10); i++;		*/
/*	XtSetArg(args[i], XiNlength, (XtArgVal) 15); i++;		*/
/*	XtSetArg(args[i], XiNwidth, (XtArgVal) 150); i++;		*/
/*	XtSetArg(args[i], XiNheight, (XtArgVal) 100); i++;		*/
	testButton = XtCreateManagedWidget("testButton",
		xiButtonWidgetClass, testBox, args, i);
	XtAddCallback(testButton, XiNselectCallback,
		PrintSelection, NULL);
/*	XiButtonSetValue(testButton, 15);						*/
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Quit"); i++;
	XtSetArg(args[i], XtNfromVert, (XtArgVal) testButton); i++;
	quit = XtCreateManagedWidget("quit",
		commandWidgetClass, testBox, args, i);
	XtAddCallback(quit, XtNcallback, Quit, NULL);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Change Label"); i++;
	XtSetArg(args[i], XtNfromVert, (XtArgVal) quit); i++;
	changeButton = XtCreateManagedWidget("changeButton",
		commandWidgetClass, testBox, args, i);
	XtAddCallback(changeButton, XtNcallback, ChangeLabel, NULL);
	XtRealizeWidget(topLevel);
	XtMainLoop();
}	/* main */


/*ARGSUSED*/
void PrintSelection(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	if (XiButtonGetValue(w) == XiBUTTON_NOVALUE)
		printf("The current button has NO value.\n");
	else
		printf("The current button has value: %d\n",
			XiButtonGetValue(w));
}	/* PrintSelection */


/*ARGSUSED*/
void ChangeLabel(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	Arg args[2];
	int i;

	i = 0;
	XtSetArg(args[i], XiNlabel, (XtArgVal) "New Label"); i++;
	XtSetValues(testButton, args, i);
}	/* ChangeLabel */


/*ARGSUSED*/
void Quit(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	printf("Button value: %d\n", XiButtonGetValue(testButton));
	XFreeFont(XtDisplay(w), font);
	exit(0);
}	/* Quit */

