/****  testchoice.c  ****  tests the choice box widget ****/


#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/cursorfont.h>

#ifdef X11R3
#include <X11/Command.h>
#include <X11/Form.h>
#else
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#endif

#include <Ximisc.h>
#include "Choice.h"


/*
Functions:
*/

void PrintItemInfo(), Quit();


/*
Private globals:
*/

static Widget testChoice;
static XFontStruct *font;


/*
main() sets up a choice box with command buttons for quitting
the application and for testing several of the Choice widget
functions.  Several resource values are tested as well.
*/

void main(argc, argv)
int argc;
char **argv;
{
	Widget topLevel, testBox, printItemInfo, quit;
	Arg args[10];
	int i;
	Cursor dot_cursor;

	topLevel = XtInitialize(argv[0], "TestChoice",
		NULL, 0, &argc, argv);
	font = load_font(topLevel, "testchoice", "6x13");
	i = 0;
	testBox = XtCreateManagedWidget("testBox", formWidgetClass,
		topLevel, args, i);
	i = 0;
	XtSetArg(args[i], XiNlabel, (XtArgVal) "Demo Choice Box"); i++;
/*	XtSetArg(args[i], XtNborderWidth, (XtArgVal) 2); i++;		*/
/*	XtSetArg(args[i], XiNfont, (XtArgVal) font); i++;			*/
/*	XtSetArg(args[i], XiNdefaultItem, (XtArgVal) 3); i++;		*/
/*	XtSetArg(args[i], XiNexclusive, (XtArgVal) TRUE); i++;		*/
/*	dot_cursor = XCreateFontCursor(XtDisplay(topLevel), XC_dot);
	XtSetArg(args[i], XiNitemCursor, (XtArgVal) dot_cursor); i++;*/
	testChoice = XtCreateManagedWidget("testChoice",
		xiChoiceWidgetClass, testBox, args, i);
	XiChoiceAddItem(testChoice, "Item 1", 10, NULL, NULL);
	XiChoiceAddItem(testChoice, "Item 2", 20, NULL, NULL);
	XiChoiceAddItem(testChoice, "Item 3", 30, NULL, NULL);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Quit"); i++;
	XtSetArg(args[i], XtNfromVert, (XtArgVal) testChoice); i++;
	quit = XtCreateManagedWidget("quit",
		commandWidgetClass, testBox, args, i);
	XtAddCallback(quit, XtNcallback, Quit, NULL);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Print Item Info"); i++;
	XtSetArg(args[i], XtNfromVert, (XtArgVal) quit); i++;
	printItemInfo = XtCreateManagedWidget("printItemInfo",
		commandWidgetClass, testBox, args, i);
	XtAddCallback(printItemInfo, XtNcallback, PrintItemInfo, NULL);
	XtRealizeWidget(topLevel);
	XtMainLoop();
}	/* main */


/*ARGSUSED*/
void PrintItemInfo(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	int *item = XiChoiceGetItems(testChoice);

	printf("\nCurrently selected item(s) are:\n");
	if (XiChoiceGetNumItems(testChoice) == 0)
		printf("-- none --\n");
	else
		while (*item) {
			printf("Choice item: %d; ", *item);
			printf("Choice value: %d\n",
				XiChoiceGetValue(testChoice, *item++));
		}
	printf("Number of items currently selected: %d\n",
		XiChoiceGetNumItems(testChoice));
	printf("Choice mode: %s\n", (XiChoiceIsExclusive(testChoice)) ?
		"Exclusive" : "Non-exclusive");
	if (XiChoiceIsExclusive(testChoice))	/* test these function */
		printf("Current item is item #: %d\n",
			XiChoiceGetSelectedItem(testChoice));
	if (XiChoiceSelectedItemIsDefault(testChoice))
		printf("(The current item is the default.)\n");
}	/* PrintItemInfo */


/*ARGSUSED*/
void Quit(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	XFreeFont(XtDisplay(w), font);
	exit(0);
}	/* Quit */

