/****  testchoice3.c  ****  tests the choice box widget ****/


#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#ifdef X11R3
#include <X11/Command.h>
#include <X11/Form.h>
#else
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#endif

#include <Ximisc.h>
#include "Choice.h"


/*
Functions:
*/

void PrintItemInfo(), Quit(), SelectDefault();


/*
Private globals:
*/

static Widget testChoice, testChoice2;
static XFontStruct *font;
static XiChoiceItem item_list[] = {	/* alphabetical ordering */
	{"Bin", 2, NULL, NULL},
	{"Dec", 10, NULL, NULL},
	{"Hex", 16, NULL, NULL},
	{"Oct", 8, NULL, NULL},
	{NULL, NULL, NULL, NULL},
};
static XiChoiceItem item_list2[] = {	/* alphabetical ordering */
	{"Yes", 1, NULL, NULL},
	{"No", 0, NULL, NULL},
	{NULL, NULL, NULL, NULL},
};


/*
main() sets up a choice box with command buttons for quitting
the application and for testing several of the Choice widget
functions.  Several resource values are tested as well.
*/

void main(argc, argv)
int argc;
char **argv;
{
	Widget topLevel, testBox, printItemInfo, selectDefault, quit;
	Arg args[10];
	int i;

	topLevel = XtInitialize(argv[0], "TestChoice3",
		NULL, 0, &argc, argv);
	font = load_font(topLevel, "testchoice3", "8x13");
	i = 0;
	testBox = XtCreateManagedWidget("testBox", formWidgetClass,
		topLevel, args, i);
	i = 0;
	XtSetArg(args[i], XiNlabel, (XtArgVal) "Base:"); i++;
	XtSetArg(args[i], XtNborderWidth, (XtArgVal) 0); i++;
	XtSetArg(args[i], XiNitemBorderWidth, (XtArgVal) 0); i++;
/*	XtSetArg(args[i], XiNvertical, (XtArgVal) TRUE); i++;		*/
	XtSetArg(args[i], XiNfont, (XtArgVal) font); i++;
	XtSetArg(args[i], XiNdefaultItem, (XtArgVal) 2); i++;		
	XtSetArg(args[i], XiNexclusive, (XtArgVal) TRUE); i++;		
	XtSetArg(args[i], XiNlabelOnLeft, (XtArgVal) TRUE); i++;
	testChoice = XtCreateManagedWidget("testChoice",
		xiChoiceWidgetClass, testBox, args, i);
	XiChoiceAddItems(testChoice, item_list);
	i = 0;
	XtSetArg(args[i], XiNlabel, (XtArgVal) "Other:"); i++;
	XtSetArg(args[i], XtNborderWidth, (XtArgVal) 0); i++;
	XtSetArg(args[i], XiNitemBorderWidth, (XtArgVal) 0); i++;
/*	XtSetArg(args[i], XiNvertical, (XtArgVal) TRUE); i++;		*/
	XtSetArg(args[i], XiNfont, (XtArgVal) font); i++;
	XtSetArg(args[i], XiNdefaultItem, (XtArgVal) 1); i++;		
	XtSetArg(args[i], XiNexclusive, (XtArgVal) TRUE); i++;		
	XtSetArg(args[i], XiNlabelOnLeft, (XtArgVal) TRUE); i++;
	XtSetArg(args[i], XtNfromVert, (XtArgVal) testChoice); i++;
	testChoice2 = XtCreateManagedWidget("testChoice2",
		xiChoiceWidgetClass, testBox, args, i);
	XiChoiceAddItems(testChoice2, item_list2);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Quit"); i++;
	XtSetArg(args[i], XtNfromVert, (XtArgVal) testChoice2); i++;
	quit = XtCreateManagedWidget("quit",
		commandWidgetClass, testBox, args, i);
	XtAddCallback(quit, XtNcallback, Quit, NULL);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Print Item Info"); i++;
	XtSetArg(args[i], XtNfromVert, (XtArgVal) quit); i++;
	printItemInfo = XtCreateManagedWidget("printItemInfo",
		commandWidgetClass, testBox, args, i);
	XtAddCallback(printItemInfo, XtNcallback, PrintItemInfo, NULL);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Select Default Item"); i++;
	XtSetArg(args[i], XtNfromVert, (XtArgVal) printItemInfo); i++;
	selectDefault = XtCreateManagedWidget("selectDefault",
		commandWidgetClass, testBox, args, i);
	XtAddCallback(selectDefault, XtNcallback, SelectDefault, NULL);
	XtRealizeWidget(topLevel);
	XtMainLoop();
}	/* main */


/*ARGSUSED*/
void PrintItemInfo(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	int i, *item = XiChoiceGetItems(testChoice);

	printf("\nCurrently selected item(s) are:\n");
	if (XiChoiceGetNumItems(testChoice) == 0)
		printf("-- none --\n");
	else
		while (*item) {
			printf("Choice item: %d; ", *item);
			printf("Choice value: %d\n",
				XiChoiceGetValue(testChoice, *item++));
		}
	if (XiChoiceItemIsSelected(testChoice, 3)) {
		printf("Note: the third item was selected,\n");
		printf("but it's just been deselected.\n");
		XiChoiceDeselectItem(testChoice, 3);
	}
	printf("Number of items currently selected: %d\n",
		XiChoiceGetNumItems(testChoice));
	printf("Choice mode: %s\n", (XiChoiceIsExclusive(testChoice)) ?
		"Exclusive" : "Non-exclusive");
	if (i = XiChoiceGetDefaultItem(testChoice))
		printf("The default item is item #: %d\n", i);
	if (XiChoiceIsExclusive(testChoice))
		printf("Current item is item #: %d\n",
			XiChoiceGetSelectedItem(testChoice));
	if (XiChoiceSelectedItemIsDefault(testChoice))
		printf("(The current item is the default.)\n");
}	/* PrintItemInfo */


/*ARGSUSED*/
void SelectDefault(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	XiChoiceSelectItem(testChoice,
		XiChoiceGetDefaultItem(testChoice));
}	/* SelectDefault */


/*ARGSUSED*/
void Quit(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	XFreeFont(XtDisplay(w), font);
	exit(0);
}	/* Quit */

