/**  testmenu.c  **  tests the menu version of the choice widget **/


#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#ifdef  X11R3
#include <X11/Command.h>
#include <X11/Form.h>
#else
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#endif

#include <Ximisc.h>
#include "Choice.h"


/*
Functions:
*/

void Quit(), DoMenu(), MenuCB();


/*
Private globals:
*/

static Widget menuShell, autoChoice;

static XiChoiceMenuItem auto_list[] = {
/*	{<manufacturer>,	<action>,	<action data>},	*/
	{"BMW 2002",		MenuCB,		"Enough said."},
	{"Mazda 626",		MenuCB,		"4-door performance!"},
	{"Saab 9000",		MenuCB,		"Wow!"},
	{"Volvo 242",		MenuCB,		"A durable classic."},
	{NULL,				NULL,		NULL},
};


/*
main() sets up a choice box with command buttons for quitting
the application and for testing several of the Choice widget
functions.  Several resource values are tested as well.
*/

void main(argc, argv)
int argc;
char **argv;
{
	Widget topLevel, testBox, doMenu, quit;
	Arg args[10];
	int i;

	topLevel = XtInitialize(argv[0], "TestMenu",
		NULL, 0, &argc, argv);
	i = 0;
	testBox = XtCreateManagedWidget("testBox", formWidgetClass,
		topLevel, args, i);
	i = 0;
	menuShell = XtCreatePopupShell("menuShell",
		transientShellWidgetClass, topLevel, args, i);
/*	XtSetArg(args[i], XiNlabelOnLeft, (XtArgVal) TRUE); i++;*/
	XtSetArg(args[i], XiNlabel, (XtArgVal) "Great Cars"); i++;
	XtSetArg(args[i], XiNitemBorderWidth, (XtArgVal) 1); i++;
	XtSetArg(args[i], XiNmenuForm, (XtArgVal) TRUE); i++;
	autoChoice = XtCreateManagedWidget("autoChoice",
		xiChoiceWidgetClass, menuShell, args, i);
	XiChoiceAddItems(autoChoice, auto_list);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Quit"); i++;
	quit = XtCreateManagedWidget("quit",
		commandWidgetClass, testBox, args, i);
	XtAddCallback(quit, XtNcallback, Quit, NULL);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Great Cars"); i++;
	XtSetArg(args[i], XtNfromHoriz, (XtArgVal) quit); i++;
	doMenu = XtCreateManagedWidget("doMenu",
		commandWidgetClass, testBox, args, i);
	XtAddCallback(doMenu, XtNcallback, DoMenu, NULL);
	XtRealizeWidget(topLevel);
	XtMainLoop();
}	/* main */


/*ARGSUSED*/
void DoMenu(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	XiChoiceMenuPopup(autoChoice);
}	/* DoMenu */


/*ARGSUSED*/
void MenuCB(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	printf("\n%s\n", client_data);
}	/* MenuCB */


/*ARGSUSED*/
void Quit(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	exit(0);
}	/* Quit */

