/****    FileSelecP.h    ****/

/****    private declarations/definitions for FileSelect.c    ****/


#ifndef	_XiFileSelectP_h
#define	_XiFileSelectP_h


#include "FileSelect.h"
#ifdef X11R3
#include <X11/VPanedP.h>
#else
#include <X11/Xaw/PanedP.h>
#endif

#define FILE_DEFAULT_FILTER			"*"

#define FILE_DEFAULT_WIDTH			300
#define FILE_DEFAULT_HEIGHT			150
#define FILE_DEFAULT_FILTER_WIDTH	150

#define FILE_DEFAULT_ROWS			10
#define FILE_DEFAULT_COLUMNS		30
#define FILE_DEFAULT_PIXMAP_ROWS	50
#define FILE_DEFAULT_PIXMAP_COLUMNS	100
#define FILE_DEFAULT_ROW_SPACING	2

#define FILE_MIN_FILTER_WIDTH		20
#define FILE_MIN_ROWS				1
#define FILE_MIN_COLUMNS			10

#define FILE_MAX_FILTER				100
#define FILE_MAX_FILE_SPEC			1280	/* 1024 + 255 + 1 */

#define FILE_DELIMITERS			"\n\r\t "	/* used with strtok() */
#define EOS						'\0'

#define FILE_NO_HIGHLIGHT		-1	/* ignore mouse, just	*/
									/* redisplay files		*/
#define FILE_NO_FILE			-2	/* no currently selected file */


typedef struct _XiFileSelectClassPart {		/* class definition */
	int dummy;
} XiFileSelectClassPart;

typedef struct _XiFileSelectClassRec {
	CoreClassPart core_class;
	CompositeClassPart composite_class;
	ConstraintClassPart constraint_class;
#ifdef X11R3
	VPanedClassPart vpaned_class;
#else
	PanedClassPart vpaned_class;
#endif
	XiFileSelectClassPart file_select_class;
} XiFileSelectClassRec;

extern XiFileSelectClassRec xiFileSelectClassRec;


typedef struct _XiFileSelectPart {		/* instance definition */
	char *filenames;					/* the list of files */
	char *filter;						/* text entry area */
	char *default_filter;				/* start-up filter */
	XFontStruct *font;
	Dimension filter_width;				/* ftr. window size--pixels */
	int rows, columns;					/* for the viewport */
	int row_spacing;					/* space between rows */
	int pixmap_rows, pixmap_columns;	/* row/column metrics */
	Cursor pixmap_cursor;
	Widget viewportW, strSelectW;
	Widget filterBoxW, labelW, filterW;
	Widget buttonBoxW, dismissButtonW,
		filterButtonW, applyButtonW;
} XiFileSelectPart;


typedef struct _XiFileSelectRec {
	CorePart core;
	CompositePart composite;
	ConstraintPart constraint;
#ifdef X11R3
	VPanedPart vpaned;
#else
	PanedPart vpaned;
#endif
	XiFileSelectPart file_select;
} XiFileSelectRec;


typedef struct {
	int dummy;
} XiFileSelectConstraintsPart;

typedef struct _XiFileSelectConstraintsRec {
#ifdef X11R3
	VPanedConstraintsPart vpaned;
#else
	PanedConstraintsPart vpaned;
#endif
	XiFileSelectConstraintsPart file_select;
} XiFileSelectConstraintsRec, *XiFileSelectConstraints;

#endif	/* _XiFileSelectP_h */
