/****    FileSelect.h    ****/

/****    public declarations/definitions for FileSelect.c    ****/

#ifndef	_XiFileSelect_h
#define	_XiFileSelect_h	1

/********************************************************************
*  Copyright (c) 1990 Iris Computing Laboratories.
*
*  This software is provided for demonstration purposes only.  As
*  freely-distributed, modifiable source code, this software carries
*  absolutely no warranty.
********************************************************************/

/********************************************************************
This module implements a file selection box that can be used by
an application to allow the user to choose/specify a file.  The user
can (1) pop up the file selection box, (2) specify a file filter,
(3) click-left on the `Filter' button to display matching files, and
then (4) click-left on a file to select it.  The application program
can determine the selected file by calling the public function
XiFileSelectGetSelection(), which returns a pointer to the selected
filename.  Using XiFileSelectAddApplyProc() the application can
supply a callback function that's executed each time the user
presses the `Apply' button.
   The file selection box is housed in a vertical pane widget.
The primary components of the pane are the text entry area for the
file filter, the scrollable display area (viewport) for listing
filenames, and the command buttons.  By default, the string selection
widget inherits its cursor from its parent.
   Typically, the file selection box would be created as a child of
a popup shell.  It's possible for the file selection box to reside
somewhere other than in a popup shell, for example, as a component of
a top-level window, or some subordinate window.  If the parent of the
the file selection box is not a popup shell, the `Dismiss' button
is inappropriate, and it will not be included.  In the latter case,
note that it is the application's responsibility to put the file
selection box where it won't be overlaid by another widget.  Note
that Xt may resize the file selection box, if it is not a child of
a popup shell; hence, the row/column dimensions for the viewport
are approximate.
   This implementation takes a conservative approach with respect to
maintaining the list of filenames that are displayed in the viewport.
Specifically, each time the user presses the `Filter' button, or
selects a file, the widget rebuilds the list of filenames.  Thus, if
the user enters a new filter, but fails to press the `Filter' button
to update the display, pressing the `Select' button will update the
viewport before making the selection.
   Although various features of the file selection box are fixed
(hard-coded), a number of features can be modified by the resources
given below.  For example, the pixmap dimensions can be specified
at creation via resource, but once it is initialized, the pixmap
cannot be resized.  Typically, the application programmer would
create the viewport to be smaller than the underlying pixmap.  Both
viewport and pixmap dimensions use row/column metrics.
   Exposures are handled by the respective internal widgets.
   Several of the calls to fprintf() are "optional."

Resources:

Name			Class			Data Type		Default		Modify?
----			-----			---------		-------		-------
XiNfilter		XiCfilter		String			"*"
XiNfilterWidth	XiCFilterWidth	Dimension		150 (pixels)
XiNrows			XiCRows			int				10
XiNcolumns		XiCColumns		int				30
XiNpixmapRows	XiCPixmapRows	int				50
XiNpixmapColumnsXiCPixmapColumnsint				100
XiNrowSpacing	XiCRowSpacing	int				2 (pixels)
XiNpixmapCursor	XiCPixmapCursor	Cursor			None
XiNpixmapFont	XiCPixmapFont	XFontStruct *	XtDefaultFont

   Public interfaces are described below.
********************************************************************/

#ifdef X11R3
#include <X11/VPaned.h>
#else
#include <X11/Xaw/Paned.h>
#endif


/*
Resource definitions:
*/

#define XiNfilter			"filter"
#define XiNfilterWidth		"filterWidth"
#define XiNrows				"rows"
#define XiNcolumns			"columns"
#define XiNpixmapRows		"pixmapRows"
#define XiNpixmapColumns	"pixmapColumns"
#define XiNrowSpacing		"rowSpacing"
#define XiNpixmapCursor		"pixmapCursor"
#define XiNpixmapFont 		"pixmapFont"
#define XiCFilter			"Filter"
#define XiCFilterWidth		"FilterWidth"
#define XiCRows				"Rows"
#define XiCColumns			"Columns"
#define XiCPixmapRows		"PixmapRows"
#define XiCPixmapColumns	"PixmapColumns"
#define XiCRowSpacing		"RowSpacing"
#define XiCPixmapCursor		"PixmapCursor"
#define XiCPixmapFont		"PixmapFont"


typedef struct _XiFileSelectClassRec *XiFileSelectWidgetClass;
typedef struct _XiFileSelectRec *XiFileSelectWidget;

extern WidgetClass xiFileSelectWidgetClass;


/*
Public functions:
*/

extern void XiFileSelectPopup();
/*	XiFileSelectWidget file_select_widget;
*/

extern char *XiFileSelectGetSelection();
/*	XiFileSelectWidget file_select_widget;
*/

extern void XiFileSelectAddApplyProc();
/*	XiFileSelectWidget file_select_widget;
*/

extern void XiFileSelectRefresh();
/*	XiFileSelectWidget file_select_widget;
*/


#endif /* _XiFileSelect_h  */
