/****  testfilesel.c  ****  tests the file selection box widget ****/


#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#ifdef X11R3
#include <X11/Box.h>
#include <X11/Command.h>
#else
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#endif

#include <Ximisc.h>
#include "FileSelect.h"


/*
Functions:
*/

void Quit(), PrintSelection(), TestFileSelectBox();


/*
Private globals:
*/

static Widget testFileSelectBox;
static XFontStruct *font;


/*
main() sets up a button-activated file selection box inside a
popup shell.  A simple callback is used to test the retrieval
facilities for the currently selected file.
*/

void main(argc, argv)
int argc;
char **argv;
{
	Widget topLevel, fileSelectShell, testBox,
		testButton, quitButton;
	Arg args[5];
	int i;

	topLevel = XtInitialize(argv[0], "TestFileSel", NULL, 0, &argc, argv);
	font = load_font(topLevel, "testfilesel", "8x13");
	i = 0;
	XtSetArg(args[i], XtNallowShellResize, (XtArgVal) TRUE); i++;
	fileSelectShell = XtCreatePopupShell("fileSelectShell",
		transientShellWidgetClass, topLevel, args, i);
	i = 0;
	XtSetArg(args[i], XiNpixmapFont, (XtArgVal) font); i++;
	testFileSelectBox = XtCreateManagedWidget("testFileSelectBox",
		xiFileSelectWidgetClass, fileSelectShell, args, i);
	XiFileSelectAddApplyProc(testFileSelectBox, PrintSelection);
	testBox = XtCreateManagedWidget("box", boxWidgetClass,
		topLevel, NULL, 0);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "File Selection Box"); i++;
	testButton = XtCreateManagedWidget("testButton",
		commandWidgetClass, testBox, args, i);
	XtAddCallback(testButton, XtNcallback, TestFileSelectBox, NULL);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Quit"); i++;
	quitButton = XtCreateManagedWidget("quitButton",
		commandWidgetClass, testBox, args, i);
	XtAddCallback(quitButton, XtNcallback, Quit, NULL);
	XtRealizeWidget(topLevel);
	XtMainLoop();
}	/* main */


/*ARGSUSED*/
void TestFileSelectBox(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	XiFileSelectPopup(testFileSelectBox);
}	/* TestFileSelectBox */


/*ARGSUSED*/
void PrintSelection(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	/*
	Alternate approach:
	*/
	printf("The current selection is: %s\n",
		XiFileSelectGetSelection(testFileSelectBox));
}	/* PrintSelection */


/*ARGSUSED*/
void Quit(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	XFreeFont(XtDisplay(w), font);
	exit(0);
}	/* Quit */

