/****  testfilesel2.c  ****  tests the file selection box widget ****/


#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/cursorfont.h>


#ifdef X11R3
#include <X11/Box.h>
#include <X11/Command.h>
#include <X11/Form.h>
#else
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#endif

#include <Ximisc.h>
#include "FileSelect.h"


/*
Functions:
*/

void Quit(), PrintSelection();

/*
Private globals:
*/

static Widget testFileSelectBox;
static XFontStruct *font;


/*
main() sets up a button-activated file selection box inside a
box widget in the main window.  A simple callback is used to
test the retrieval facilities for the currently selected file.
*/

void main(argc, argv)
int argc;
char **argv;
{
	Widget topLevel, testBox, quitButton;
	Arg args[5];
	int i;
	Cursor pixmap_cursor;

	topLevel = XtInitialize(argv[0], "TestFileSel2",
		NULL, 0, &argc, argv);
	font = load_font(topLevel, "testfilesel2", "8x13");
	testBox = XtCreateManagedWidget("testBox", formWidgetClass,
		topLevel, NULL, 0);
	i = 0;
	XtSetArg(args[i], XiNrows,			/* just testing */
		(XtArgVal) 20); i++;	
	XtSetArg(args[i], XiNcolumns,		/* just testing */
		(XtArgVal) 40); i++;
/*	pixmap_cursor = XCreateFontCursor(XtDisplay(topLevel), XC_dot);
	XtSetArg(args[i], XiNpixmapCursor, (XtArgVal) pixmap_cursor); i++;*/
	XtSetArg(args[i], XiNrowSpacing,	/* just testing */
		(XtArgVal) 5); i++;	
	XtSetArg(args[i], XiNpixmapFont,	/* just testing */
		(XtArgVal) font); i++;	
	testFileSelectBox = XtCreateManagedWidget("testFileSelectBox",
		xiFileSelectWidgetClass, testBox, args, i);
	XiFileSelectAddApplyProc(testFileSelectBox, PrintSelection);
	i = 0;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Quit"); i++;
	XtSetArg(args[i], XtNfromVert, (XtArgVal) testFileSelectBox); i++;
	quitButton = XtCreateManagedWidget("quitButton",
		commandWidgetClass, testBox, args, i);
	XtAddCallback(quitButton, XtNcallback, Quit, NULL);
	XtRealizeWidget(topLevel);
	XtMainLoop();
}	/* main */


/*ARGSUSED*/
void PrintSelection(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	printf("The current selection is: %s\n",
		XiFileSelectGetSelection(testFileSelectBox));
}	/* PrintSelection */


/*ARGSUSED*/
void Quit(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	XFreeFont(XtDisplay(w), font);
	exit(0);
}	/* Quit */

