/****    SimpleTexP.h    ****/

/****    private declarations/definitions for SimpleText.c    ****/


#ifndef	_XiSimpleTextP_h
#define	_XiSimpleTextP_h


#include "SimpleText.h"
#ifdef X11R3
#include <X11/FormP.h>
#else
#include <X11/Xaw/FormP.h>
#endif


#define TEXT_DEFAULT_WIDTH		400
#define TEXT_DEFAULT_HEIGHT		175
#define TEXT_DEFAULT_TEXT_WIDTH	300

#define TEXT_DEFAULT_LABEL		""
#define TEXT_DEFAULT_TEXT		""

#define TEXT_MAX_TEXT_LEN		256


typedef struct _XiSimpleTextClassPart {		/* class definition */
	int dummy;
} XiSimpleTextClassPart;

typedef struct _XiSimpleTextClassRec {
	CoreClassPart core_class;
	CompositeClassPart composite_class;
	ConstraintClassPart constraint_class;
	FormClassPart form_class;
	XiSimpleTextClassPart simple_text_class;
} XiSimpleTextClassRec;

extern XiSimpleTextClassRec xiSimpleTextClassRec;

typedef struct _XiSimpleTextPart {			/* instance definition */
	char *label;
	char *text;
	char *default_text;
	Dimension text_width;
	XFontStruct *font;
	Widget labelW;
	Widget textW;
} XiSimpleTextPart;


typedef struct _XiSimpleTextRec {
	CorePart core;
	CompositePart composite;
	ConstraintPart constraint;
	FormPart form;
	XiSimpleTextPart simple_text;
} XiSimpleTextRec;


typedef struct {
	int dummy;
} XiSimpleTextConstraintsPart;


typedef struct _XiSimpleTextConstraintsRec {
	FormConstraintsPart form;
	XiSimpleTextConstraintsPart simple_text;
} XiSimpleTextConstraintsRec, *XiSimpleTextConstraints;

#endif	/* _XiSimpleTextP_h */
