/****  testtext.c  ****  tests the simple text entry widget ****/


#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#ifdef X11R3
#include <X11/Box.h>
#include <X11/Command.h>
#include <X11/Form.h>
#else
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#endif
#include <Ximisc.h>
#include "SimpleText.h"


/*
Functions:
*/

void TestGetText(), TestSetText(), Quit();


/*
Private globals:
*/

static Widget testText;
static XFontStruct *font;


void main(argc, argv)
int argc;
char **argv;
{
	Widget topLevel, testBox, getButton, setButton, quitButton;
	Arg args[7];
	int i;

	topLevel = XtInitialize(argv[0], "TestText",
		NULL, 0, &argc, argv);
	font = load_font(topLevel, "testtext", "8x13");
	testBox = XtCreateManagedWidget("testBox", formWidgetClass,
		topLevel, NULL, 0);
	i = 0;
	XtSetArg(args[i], XtNborderWidth, (XtArgVal) 0); i++;
	XtSetArg(args[i], XiNtextWidth, (XtArgVal) 200); i++;
	XtSetArg(args[i], XiNlabel, (XtArgVal) "Any Label:"); i++;
	XtSetArg(args[i], XiNtext, (XtArgVal) "Start-up Text"); i++;
	XtSetArg(args[i], XtNfont,		/* test with an		*/
		(XtArgVal) font); i++;		/* alternate font	*/
	testText = XtCreateManagedWidget("testText",
		xiSimpleTextWidgetClass, testBox, args, i);
	i = 0;
	XtSetArg(args[i], XtNfromVert, (XtArgVal) testText); i++;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Get Text"); i++;
	getButton = XtCreateManagedWidget("getButton",
		commandWidgetClass, testBox, args, i);
	i = 0;
	XtSetArg(args[i], XtNfromVert, (XtArgVal) testText); i++;
	XtSetArg(args[i], XtNfromHoriz, (XtArgVal) getButton); i++;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Set Text"); i++;
	setButton = XtCreateManagedWidget("setButton",
		commandWidgetClass, testBox, args, i);
	i = 0;
	XtSetArg(args[i], XtNfromVert, (XtArgVal) testText); i++;
	XtSetArg(args[i], XtNfromHoriz, (XtArgVal) setButton); i++;
	XtSetArg(args[i], XtNlabel, (XtArgVal) "Quit"); i++;
	quitButton = XtCreateManagedWidget("quitButton",
		commandWidgetClass, testBox, args, i);
	XtAddCallback(getButton, XtNcallback, TestGetText, NULL);
	XtAddCallback(setButton, XtNcallback, TestSetText, NULL);
	XtAddCallback(quitButton, XtNcallback, Quit, NULL);
	XtRealizeWidget(topLevel);
	XtMainLoop();
}	/* main */


/*ARGSUSED*/
void TestGetText(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	char *text;

	text = XiSimpleTextGetString(testText);
	printf("Text entry box text is: %s\n", text);
}	/* TestGetText */


/*ARGSUSED*/
void TestSetText(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	XiSimpleTextSetString(testText, "abcdef");
}	/* TestSetText */


/*ARGSUSED*/
void Quit(w, client_data, call_data)
Widget w;
caddr_t client_data, call_data;
{
	XFreeFont(XtDisplay(w), font);
	exit(0);
}	/* Quit */

